/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.node.formatters;

import [Lcom.raplix.rolloutexpress.node.upgrade.UpgradeTaskSummary;;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskSummary;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterNotFoundException;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.node.formatters.PackageInfo;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class FormatterBase
implements Formatter {
    private static final String NO_RESULT = "ui.node.format.NO_RESULT";

    private Object convert(Object src, Class dstClass) throws Exception {
        try {
            return Context.getConverterHandler().convert(src, dstClass);
        }
        catch (ConverterNotFoundException ex) {
            return null;
        }
    }

    private void write(Object src, PrintWriter pw) throws Exception {
        if (src == null) {
            pw.println(Context.getMessageText(NO_RESULT));
            return;
        }
        Object result = this.convert(src, UpgradeTaskStatus.class);
        if (result != null) {
            this.write((UpgradeTaskStatus)result, pw);
            return;
        }
        result = this.convert(src, UpgradeTaskSummary;.class);
        if (result != null) {
            this.write((UpgradeTaskSummary[])result, pw);
            return;
        }
        PackageInfo.throwCannotWrite(src);
    }

    protected abstract void write(UpgradeTaskStatus var1, PrintWriter var2) throws Exception;

    protected abstract void write(UpgradeTaskSummary[] var1, PrintWriter var2) throws Exception;

    public void write(Object src, OutputStream out) throws Exception {
        PrintWriter pw = new PrintWriter(out);
        this.write(src, pw);
        pw.flush();
    }
}

