/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.node.commands;

import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.node.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Arrays;
import java.util.Vector;

public class NodeUpgradeTaskRun
extends SessionBase {
    private static CommandHelp sHelp = new NodeUpgradeTaskRunHelp();
    private UpgradeTaskID mResult;
    private boolean mAll = false;
    private HostID[] mHostIDs;
    private HostSetID[] mHostSetIDs;
    private AppInstanceID[] mAppInstanceIDArr;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$node$commands$NodeUpgradeTaskRun;

    public CommandHelp getHelp() {
        return sHelp;
    }

    public HostID[] getHostIDArray() {
        return this.mHostIDs;
    }

    public void setHostIDArray(HostID[] hostIDs) {
        this.mHostIDs = hostIDs;
    }

    public HostSetID[] getHostSetIDArray() {
        return this.mHostSetIDs;
    }

    public void setHostSetIDArray(HostSetID[] hostSetIDs) {
        this.mHostSetIDs = hostSetIDs;
    }

    public AppInstanceID[] getAppInstanceIDArray() {
        return this.mAppInstanceIDArr;
    }

    public void setAppInstanceIDArray(AppInstanceID[] appInstanceIDArr) {
        this.mAppInstanceIDArr = appInstanceIDArr;
    }

    public boolean getAll() {
        return this.mAll;
    }

    public void setAll(boolean all) {
        this.mAll = all;
    }

    public UpgradeTaskID getResult() {
        return this.mResult;
    }

    protected void setResult(UpgradeTaskID result) {
        this.mResult = result;
    }

    public void execute() throws Exception {
        this.validateUserInput();
        NodeManagementServices nodeMS = Context.getNodeManagementServices();
        if (this.mAll) {
            this.setResult(nodeMS.upgradeEntireNetwork());
        } else if (null != this.mHostIDs || null != this.mHostSetIDs || null != this.mAppInstanceIDArr) {
            AppInstance[] apps;
            AppInstanceIDSet allAppInstanceIDs = new AppInstanceIDSet();
            if (this.mAppInstanceIDArr != null && this.mAppInstanceIDArr.length > 0) {
                allAppInstanceIDs.addAll(Arrays.asList(this.mAppInstanceIDArr));
            }
            HostIDSet hset = new HostIDSet();
            if (this.mHostIDs != null && this.mHostIDs.length > 0) {
                hset.addAll(Arrays.asList(this.mHostIDs));
            }
            if (this.mHostSetIDs != null && this.mHostSetIDs.length > 0) {
                for (int i = 0; i < this.mHostSetIDs.length; ++i) {
                    SummaryHost[] hosts = this.mHostSetIDs[i].getAllHostsQuery().selectSummaryView();
                    for (int j = 0; j < hosts.length; ++j) {
                        SummaryHost host = hosts[j];
                        hset.add(host.getID());
                    }
                }
            }
            if ((apps = hset.getAllAppInstancesQuery().select()) != null && apps.length > 0) {
                for (int i = 0; i < apps.length; ++i) {
                    allAppInstanceIDs.add(apps[i].getID());
                }
            }
            if (!allAppInstanceIDs.isEmpty()) {
                this.setResult(nodeMS.upgradeMultipleNodes((AppInstanceID[])allAppInstanceIDs.toArray()));
            } else {
                PackageInfo.throwNoAppInstancesForHost();
            }
        }
    }

    private void validateUserInput() throws Exception {
        if (!(null != this.mHostIDs && 0 < this.mHostIDs.length || null != this.mHostSetIDs && 0 < this.mHostSetIDs.length || null != this.mAppInstanceIDArr && 0 < this.mAppInstanceIDArr.length || this.mAll)) {
            PackageInfo.throwNoTagIllegalForAutoUpgradeRun();
        }
        if ((null != this.mHostIDs && 0 < this.mHostIDs.length || null != this.mHostSetIDs && 0 < this.mHostSetIDs.length || null != this.mAppInstanceIDArr && 0 < this.mAppInstanceIDArr.length) && this.mAll) {
            PackageInfo.throwTagIllegalForAutoUpgradeRun();
        }
    }

    protected static class NodeUpgradeTaskRunHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.node.au.run.";
        private static final String HOSTID_DESC = "KEY:ui.node.au.run.HOSTID_DESC";
        private static final String HOSTSETID_DESC = "KEY:ui.node.au.run.HOSTSETID_DESC";
        private static final String APPINSTANCEID_DESC = "KEY:ui.node.au.run.APPINSTANCEID_DESC";
        private static final String ALL_DESC = "KEY:ui.node.au.run.ALL_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.node.au.run.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.node.au.run.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("hostIDArray", HOSTID_DESC, "hID"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("hostSetIDArray", HOSTSETID_DESC, "hsID"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("appInstanceIDArray", APPINSTANCEID_DESC, "ID"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("all", ALL_DESC));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        NodeUpgradeTaskRunHelp() {
            super(class$com$raplix$rolloutexpress$ui$node$commands$NodeUpgradeTaskRun == null ? (class$com$raplix$rolloutexpress$ui$node$commands$NodeUpgradeTaskRun = NodeUpgradeTaskRun.class$("com.raplix.rolloutexpress.ui.node.commands.NodeUpgradeTaskRun")) : class$com$raplix$rolloutexpress$ui$node$commands$NodeUpgradeTaskRun, MSG_COMMAND_DESC);
        }
    }
}

