/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.net.formatters;

import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterNotFoundException;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.net.UINetMessage;
import com.raplix.rolloutexpress.ui.net.converters.UITraceResult;
import com.raplix.rolloutexpress.ui.net.formatters.NetUtil;
import java.io.OutputStream;
import java.io.PrintWriter;

public class SummaryFormatter
implements Formatter {
    private Object convert(Object src, Class dstClass) throws Exception {
        try {
            return Context.getConverterHandler().convert(src, dstClass);
        }
        catch (ConverterNotFoundException ex) {
            return null;
        }
    }

    private void write(Object src, PrintWriter pw) throws Exception {
        if (src == null) {
            pw.println("No result");
            return;
        }
        Object result = this.convert(src, UITraceResult.class);
        if (result != null) {
            this.write((UITraceResult)result, pw);
            return;
        }
        result = this.convert(src, PingResult.class);
        if (result != null) {
            this.write((PingResult)result, pw);
            return;
        }
        throw new IllegalArgumentException(new UINetMessage(UINetMessage.CANNOT_WRITE_OBJECT, src.toString()).toString());
    }

    public void write(UITraceResult src, PrintWriter pw) throws Exception {
        NetUtil.write(pw, src, "");
    }

    public void write(PingResult src, PrintWriter pw) throws Exception {
        NetUtil.write(pw, src, "");
    }

    public void write(Object src, OutputStream stream) throws Exception {
        PrintWriter writer = new PrintWriter(stream);
        this.write(src, writer);
        writer.flush();
    }
}

