/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.net.formatters;

import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.TraceFailed;
import com.raplix.rolloutexpress.net.transport.TraceResult;
import com.raplix.rolloutexpress.ui.net.UINetMessage;
import com.raplix.rolloutexpress.ui.net.converters.UITraceResult;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;
import java.util.Enumeration;

public class NetUtil {
    private static final String S = ":";

    private NetUtil() {
    }

    public static void write(PrintWriter pw, UITraceResult obj, String prefix) throws Exception {
        TraceFailed failure;
        pw.print(prefix);
        pw.println(UINetMessage.TRACEROUTE_RESULT_DEST + S + " " + obj.getResult().getDestinationId() + " " + (obj.getResult().isSuccess() ? UINetMessage.RESULT_SUCCESS : UINetMessage.RESULT_FAIL));
        Column[] columns = new Column[]{new Column(20, 0, UINetMessage.TRACEROUTE_RESULT_NODE.toString()), new Column(7, 0, UINetMessage.TRACEROUTE_RESULT_STATUS.toString()), new Column(6, 2, UINetMessage.TRACEROUTE_RESULT_MS.toString()), new Column(48, 0, UINetMessage.TRACEROUTE_RESULT_FAILURE.toString())};
        Enumeration hops = obj.getResult().hops();
        if (hops != null) {
            Table table = null;
            while (hops.hasMoreElements()) {
                if (table == null) {
                    table = new Table(pw, columns, prefix);
                }
                PingResult pr = (PingResult)hops.nextElement();
                String[] data = new String[]{pr.getDestinationId().toString(), pr.isSuccess() ? UINetMessage.TRACEROUTE_RESULT_SUCCESS.toString() : UINetMessage.RESULT_FAIL.toString(), String.valueOf(pr.timeTakenMillis()), pr.isSuccess() ? "" : pr.failureCodeString() + S + pr.failureString()};
                table.printRow(CollectionUtil.getEnumeration(data));
            }
            if (table != null) {
                table.endPrinting();
            }
        }
        if ((failure = obj.getFailure()) != null) {
            pw.print(prefix);
            pw.print(UINetMessage.TRACEROUTE_RESULT_FAILURE.toString());
            pw.println(failure);
        }
        pw.flush();
    }

    public static void writeDetail(PrintWriter pw, UITraceResult result, String prefix) throws Exception {
        TraceFailed failure;
        TraceResult value = result.getResult();
        pw.print(prefix);
        pw.print(UINetMessage.TRACEROUTE_RESULT_DEST + S);
        pw.println(value.getDestinationId().toString());
        pw.print(prefix);
        pw.print(UINetMessage.RESULT_RESULT + S);
        if (value.isSuccess()) {
            pw.println(UINetMessage.RESULT_SUCCESS.toString());
        } else {
            pw.println(UINetMessage.RESULT_FAIL.toString());
        }
        Enumeration enu = value.hops();
        if (enu != null) {
            int i = 1;
            while (enu.hasMoreElements()) {
                PingResult pr = (PingResult)enu.nextElement();
                pw.print(prefix);
                pw.println(UINetMessage.TRACEROUTE_RESULT_HOP + "[" + i++ + "]:");
                NetUtil.write(pw, pr, prefix);
            }
        }
        if ((failure = result.getFailure()) != null) {
            pw.print(prefix);
            pw.println(UINetMessage.TRACEROUTE_RESULT_FAILURE.toString());
            failure.printStackTrace(pw);
        }
        pw.flush();
    }

    public static void write(PrintWriter pw, PingResult value, String prefix) throws Exception {
        pw.print(prefix);
        pw.print(UINetMessage.PING_RESULT_DEST + S);
        pw.println(value.getDestinationId().toString());
        pw.print(prefix);
        pw.print(UINetMessage.RESULT_RESULT + S);
        if (value.isSuccess()) {
            pw.println(UINetMessage.RESULT_SUCCESS.toString());
            pw.print(prefix);
            pw.print(UINetMessage.PING_RESULT_ROUNDTRIP + S);
            pw.print(value.timeTakenMillis());
            pw.println(UINetMessage.PING_RESULT_MS.toString());
            pw.print(prefix);
            pw.print(UINetMessage.PING_RESULT_TTL + S);
            pw.println(value.getTTL());
        } else {
            pw.print(UINetMessage.RESULT_FAIL.toString());
            pw.print(prefix);
            pw.print(UINetMessage.PING_RESULT_CAUSE + S);
            pw.println(value.failureCodeString());
            pw.print(prefix);
            pw.print(UINetMessage.PING_RESULT_DETAIL + S);
            pw.println(value.failureString());
            pw.print(prefix);
            pw.print(UINetMessage.PING_RESULT_ROUNDTRIP + S);
            pw.print(value.timeTakenMillis());
            pw.println(UINetMessage.PING_RESULT_MS.toString());
            pw.print(prefix);
            pw.print(UINetMessage.PING_RESULT_TTL + S);
            pw.println(value.getTTL());
        }
        pw.flush();
    }
}

