/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.net.commands;

import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TraceFailed;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.net.UINetMessage;
import com.raplix.rolloutexpress.ui.net.converters.UITraceResult;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class TraceRoute
extends SessionBase
implements OutputCommand {
    private static final String HEADER_PREFIX = "ui.net.traceroute";
    private static final String MSG_START_HEADER = "ui.net.traceroute.result.start";
    private RoxAddress mDestination;
    private UITraceResult mResult;
    private static final TraceRouteHelp sHelp = new TraceRouteHelp();
    private OutputStream mOutputStream;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$net$commands$TraceRoute;

    public void setDestination(RoxAddress addr) {
        this.mDestination = addr;
    }

    public RoxAddress getDestination() {
        return this.mDestination;
    }

    public UITraceResult getResult() {
        return this.mResult;
    }

    public void setResult(UITraceResult inResult) {
        this.mResult = inResult;
    }

    public void setOutputStream(OutputStream stream) {
        this.mOutputStream = stream;
    }

    public void execute() throws Exception {
        if (this.mOutputStream == null) {
            this.setOutputStream(System.out);
        }
        PrintWriter pw = new PrintWriter(this.mOutputStream);
        pw.println(Context.getMessageText(MSG_START_HEADER));
        pw.flush();
        try {
            this.setResult(new UITraceResult(Context.getTransportServices().traceroute(this.mDestination)));
        }
        catch (TraceFailed tf) {
            this.setResult(new UITraceResult(tf));
        }
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    protected static class TraceRouteHelp
    extends SessionBase.SessionBaseHelp {
        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("destination", UINetMessage.TRACEROUTE_DESTINATION_DESC.getPrefixedKey(), "d"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", UINetMessage.TRACEROUTE_RESULT_DESC.getPrefixedKey());
        }

        TraceRouteHelp() {
            super(class$com$raplix$rolloutexpress$ui$net$commands$TraceRoute == null ? (class$com$raplix$rolloutexpress$ui$net$commands$TraceRoute = TraceRoute.class$("com.raplix.rolloutexpress.ui.net.commands.TraceRoute")) : class$com$raplix$rolloutexpress$ui$net$commands$TraceRoute, UINetMessage.TRACEROUTE_DESC.getPrefixedKey());
        }
    }
}

