/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.net.commands;

import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.net.UINetMessage;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class Ping
extends SessionBase
implements OutputCommand {
    private static final String HEADER_PREFIX = "ui.net.ping";
    private static final String MSG_START_HEADER = "ui.net.ping.result.start";
    private RoxAddress mDestination;
    private PingResult mResult;
    private static final PingHelp sHelp = new PingHelp();
    private OutputStream mOutputStream;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$net$commands$Ping;

    public void setDestination(RoxAddress addr) {
        this.mDestination = addr;
    }

    public RoxAddress getDestination() {
        return this.mDestination;
    }

    public PingResult getResult() {
        return this.mResult;
    }

    public void setResult(PingResult inResult) {
        this.mResult = inResult;
    }

    public void setOutputStream(OutputStream stream) {
        this.mOutputStream = stream;
    }

    public void execute() throws Exception {
        if (this.mOutputStream == null) {
            this.setOutputStream(System.out);
        }
        PrintWriter pw = new PrintWriter(this.mOutputStream);
        pw.println(Context.getMessageText(MSG_START_HEADER));
        pw.flush();
        this.setResult(Context.getTransportServices().ping(this.mDestination));
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    protected static class PingHelp
    extends SessionBase.SessionBaseHelp {
        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("destination", UINetMessage.PING_DESTINATION_DESC.getPrefixedKey(), "d"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", UINetMessage.PING_RESULT_DESC.getPrefixedKey());
        }

        PingHelp() {
            super(class$com$raplix$rolloutexpress$ui$net$commands$Ping == null ? (class$com$raplix$rolloutexpress$ui$net$commands$Ping = Ping.class$("com.raplix.rolloutexpress.ui.net.commands.Ping")) : class$com$raplix$rolloutexpress$ui$net$commands$Ping, UINetMessage.PING_DESC.getPrefixedKey());
        }
    }
}

