/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.formatters;

import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVar;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVarList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.hostdbx.converters.UIAppInstanceUpdate;
import com.raplix.rolloutexpress.ui.plugindb.formatters.PluginUtil;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;

public final class HostUtil {
    private static final String HOST_FORMAT_PREFIX = "ui.hdb.format.h.";
    private static final String HOST_ID_HEADER = "ui.hdb.format.h.ID_HEADER";
    private static final String HOST_NAME_HEADER = "ui.hdb.format.h.NAME_HEADER";
    private static final String HOST_DESCRIPTION_HEADER = "ui.hdb.format.h.DESCRIPTION_HEADER";
    private static final String HOST_OSNAME_HEADER = "ui.hdb.format.h.OSNAME_HEADER";
    private static final String HOST_OSVERSION_HEADER = "ui.hdb.format.h.OSVERSION_HEADER";
    private static final String HOST_OSARCHITECTURE_HEADER = "ui.hdb.format.h.OSARCHITECTURE_HEADER";
    private static final String HOST_PLATFORM_SUPPORTED = "ui.hdb.format.h.PLATFORM_SUPPORTED";
    private static final String HOST_PLATFORM_NOT_SUPPORTED = "ui.hdb.format.h.PLATFORM_NOT_SUPPORTED";
    private static final String HOST_LAST_PREPARED_HEADER = "ui.hdb.format.h.LAST_PREPARED_HEADER";
    private static final String HOST_NOT_PREPARED = "ui.hdb.format.h.NOT_PREPARED";
    private static final String HOST_IS_HIDDEN_HEADER = "ui.hdb.format.h.IS_HIDDEN_HEADER";
    private static final String HOST_IS_VIRTUAL_HEADER = "ui.hdb.format.h.IS_VIRTUAL_HEADER";
    private static final String HOST_CREATED_BY_COMPONENT_HEADER = "ui.hdb.format.h.CREATED_BY_COMPONENT";
    private static final String HOST_ATTRIBUTES_HEADER = "ui.hdb.format.h.ATTRIBUTES_HEADER";
    private static final String HOST_ATTRIBUTE_COLUMN = "ui.hdb.format.h.ATTRIBUTE_COLUMN";
    private static final String HOST_DEFAULT_COLUMN = "ui.hdb.format.h.DEFAULT_COLUMN";
    private static final String HOST_OVERRIDE_COLUMN = "ui.hdb.format.h.OVERRIDE_COLUMN";
    private static final String HOST_TYPE_ID_HEADER = "ui.hdb.format.h.TYPE_ID_HEADER";
    private static final String HOST_APPLICATIONS_HEADER = "ui.hdb.format.h.APPLICATIONS_HEADER";
    private static final String HOST_PARENT_HEADER = "ui.hdb.format.h.PARENT_HEADER";
    private static final String HOST_COLUMN_ID = "ui.hdb.format.h.COLUMN_ID";
    private static final String HOST_COLUMN_NAME = "ui.hdb.format.h.COLUMN_NAME";
    private static final String TARGET_FORMAT_PREFIX = "ui.hdb.format.t.";
    private static final String TARGET_ID_HEADER = "ui.hdb.format.t.ID_HEADER";
    private static final String TARGET_INITIAL_ID_HEADER = "ui.hdb.format.t.INITIAL_ID_HEADER";
    private static final String TARGET_INITIAL_NAME_HEADER = "ui.hdb.format.t.INITIAL_NAME_HEADER";
    private static final String TARGET_PHYSICAL_ID_HEADER = "ui.hdb.format.t.PHYSICAL_ID_HEADER";
    private static final String TARGET_PHYSICAL_NAME_HEADER = "ui.hdb.format.t.PHYSICAL_NAME_HEADER";
    private static final String TARGET_CURRENT_ID_HEADER = "ui.hdb.format.t.CURRENT_ID_HEADER";
    private static final String TARGET_CURRENT_NAME_HEADER = "ui.hdb.format.t.CURRENT_NAME_HEADER";
    private static final String HOSTTYPE_FORMAT_PREFIX = "ui.hdb.format.ht.";
    private static final String HOSTTYPE_ID_HEADER = "ui.hdb.format.ht.ID_HEADER";
    private static final String HOSTTYPE_NAME_HEADER = "ui.hdb.format.ht.NAME_HEADER";
    private static final String HOSTTYPE_DESCRIPTION_HEADER = "ui.hdb.format.ht.DESCRIPTION_HEADER";
    private static final String HOSTTYPE_FROM_PLUGIN_HEADER = "ui.hdb.format.ht.FROM_PLUGIN_HEADER";
    private static final String HOSTTYPE_IS_HIDDEN_HEADER = "ui.hdb.format.ht.IS_HIDDEN_HEADER";
    private static final String HOSTTYPE_ATTRIBUTES_HEADER = "ui.hdb.format.ht.ATTRIBUTES_HEADER";
    private static final String HOSTTYPE_ATTRIBUTE_COLUMN = "ui.hdb.format.ht.ATTRIBUTE_COLUMN";
    private static final String HOSTTYPE_DEFAULT_COLUMN = "ui.hdb.format.ht.DEFAULT_COLUMN";
    private static final String HOSTTYPE_COLUMN_ID = "ui.hdb.format.ht.COLUMN_ID";
    private static final String HOSTTYPE_COLUMN_NAME = "ui.hdb.format.ht.COLUMN_NAME";
    private static final String HOSTSET_FORMAT_PREFIX = "ui.hdb.format.hs.";
    private static final String HOSTSET_ID_HEADER = "ui.hdb.format.hs.ID_HEADER";
    private static final String HOSTSET_NAME_HEADER = "ui.hdb.format.hs.NAME_HEADER";
    private static final String HOSTSET_DESCRIPTION_HEADER = "ui.hdb.format.hs.DESCRIPTION_HEADER";
    private static final String HOSTSET_FROM_PLUGIN_HEADER = "ui.hdb.format.hs.FROM_PLUGIN_HEADER";
    private static final String HOSTSET_IS_HIDDEN_HEADER = "ui.hdb.format.hs.IS_HIDDEN_HEADER";
    private static final String HOSTSET_STATIC_HOSTS_HEADER = "ui.hdb.format.hs.STATIC_HOSTS_HEADER";
    private static final String HOSTSET_SUBHOSTS_HEADER = "ui.hdb.format.hs.SUBHOSTS_HEADER";
    private static final String HOSTSET_SUBSEARCHES_HEADER = "ui.hdb.format.hs.SUBSEARCHES_HEADER";
    private static final String HOSTSET_COLUMN_ID = "ui.hdb.format.hs.COLUMN_ID";
    private static final String HOSTSET_COLUMN_NAME = "ui.hdb.format.hs.COLUMN_NAME";
    private static final String HOSTSEARCH_FORMAT_PREFIX = "ui.hdb.format.hr.";
    private static final String HOSTSEARCH_ID_HEADER = "ui.hdb.format.hr.ID_HEADER";
    private static final String HOSTSEARCH_NAME_HEADER = "ui.hdb.format.hr.NAME_HEADER";
    private static final String HOSTSEARCH_DESCRIPTION_HEADER = "ui.hdb.format.hr.DESCRIPTION_HEADER";
    private static final String HOSTSEARCH_FROM_PLUGIN_HEADER = "ui.hdb.format.hr.FROM_PLUGIN_HEADER";
    private static final String HOSTSEARCH_IS_HIDDEN_HEADER = "ui.hdb.format.hr.IS_HIDDEN_HEADER";
    private static final String HOSTSEARCH_QUERY_HEADER = "ui.hdb.format.hr.QUERY_HEADER";
    private static final String HOSTSEARCH_FILTER_HEADER = "ui.hdb.format.hr.FILTER_HEADER";
    private static final String HOSTSEARCH_PHYSCRIT_HEADER = "ui.hdb.format.hr.PHYSCRIT_HEADER";
    private static final String HOSTSEARCH_NULLFILTER = "ui.hdb.format.hr.NULLFILTER";
    private static final String HOSTSEARCH_COLUMN_ID = "ui.hdb.format.hr.COLUMN_ID";
    private static final String HOSTSEARCH_COLUMN_NAME = "ui.hdb.format.hr.COLUMN_NAME";
    private static final String APP_FORMAT_PREFIX = "ui.hdb.format.a.";
    private static final String WARNING_HEADER = "ui.hdb.format.a.WARNING_HEADER";
    private static final String APP_ID_HEADER = "ui.hdb.format.a.ID_HEADER";
    private static final String APP_PARENT_ID_HEADER = "ui.hdb.format.a.PARENT_ID_HEADER";
    private static final String APP_HOST_ID_HEADER = "ui.hdb.format.a.HOST_ID_HEADER";
    private static final String APP_TYPE_HEADER = "ui.hdb.format.a.TYPE_HEADER";
    private static final String APP_IP_ADDRESS_HEADER = "ui.hdb.format.a.IP_ADDRESS_HEADER";
    private static final String APP_PORT_HEADER = "ui.hdb.format.a.PORT_HEADER";
    private static final String APP_PARAMETERS_HEADER = "ui.hdb.format.a.PARAMETERS_HEADER";
    private static final String APP_CONNECTION_HEADER = "ui.hdb.format.a.CONNECTION_HEADER";
    private static final String APP_COLUMN_ID = "ui.hdb.format.a.COLUMN_ID";
    private static final String APP_COLUMN_TYPE = "ui.hdb.format.a.COLUMN_TYPE";
    private static final String APP_COLUMN_PARAMETERS = "ui.hdb.format.a.COLUMN_PARAMETERS";

    private HostUtil() {
    }

    public static void write(PrintWriter pw, Host h, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_ID_HEADER) + ": " + h.getID());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_NAME_HEADER) + ": " + h.getName());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_DESCRIPTION_HEADER) + ": " + h.getDescription());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_OSNAME_HEADER) + ": " + (h.getMachineInfo() != null ? h.getMachineInfo().getOSName() + " (" + (h.getID().isSupported() ? HostUtil.toText(HOST_PLATFORM_SUPPORTED) : HostUtil.toText(HOST_PLATFORM_NOT_SUPPORTED)) + ")" : HostUtil.toText(HOST_NOT_PREPARED)));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_OSVERSION_HEADER) + ": " + (h.getMachineInfo() != null ? h.getMachineInfo().getOSVersion() : HostUtil.toText(HOST_NOT_PREPARED)));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_OSARCHITECTURE_HEADER) + ": " + (h.getMachineInfo() != null ? h.getMachineInfo().getOSArch() : HostUtil.toText(HOST_NOT_PREPARED)));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_LAST_PREPARED_HEADER) + ": " + (h.isPrepared() ? HostUtil.convert(h.getMachineInfoTimestamp(), String.class) : HostUtil.toText(HOST_NOT_PREPARED)));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_IS_VIRTUAL_HEADER) + ": " + h.isVirtual());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_IS_HIDDEN_HEADER) + ": " + Visibility.HIDDEN.equals(h.getVisibility()));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_TYPE_ID_HEADER) + ": " + h.getHostTypeID());
        if (h.getInstalledComponentID() != null) {
            pw.print(prefix);
            pw.println(HostUtil.toText(HOST_CREATED_BY_COMPONENT_HEADER) + ": " + h.getInstalledComponentID().toString());
        }
        pw.print(prefix);
        pw.println(HostUtil.toText(HOST_ATTRIBUTES_HEADER) + ":");
        Column[] columns = new Column[]{new Column(25, 0, HostUtil.toText(HOST_ATTRIBUTE_COLUMN)), new Column(15, 0, HostUtil.toText(HOST_DEFAULT_COLUMN)), new Column(15, 0, HostUtil.toText(HOST_OVERRIDE_COLUMN))};
        Table t = new Table(pw, columns, prefix + " ");
        HostType ht = h.getHostType();
        String[] varnames = h.getVarNames();
        String[] data = new String[3];
        for (int i = 0; i < varnames.length; ++i) {
            String varname = varnames[i];
            String vardef = ht.getVarValue(varname);
            String varoverride = h.getOverrideVarValue(varname);
            data[0] = varname;
            data[1] = vardef;
            data[2] = varoverride != null ? varoverride : vardef + "*";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
        pw.print(prefix);
        if (h.isVirtual()) {
            pw.println(HostUtil.toText(HOST_PARENT_HEADER) + ":");
            HostUtil.write(pw, HostUtil.toHostArray(h.getParentHostID()), " ");
        } else {
            pw.println(HostUtil.toText(HOST_APPLICATIONS_HEADER) + ":");
            HostUtil.write(pw, h.getAppInstances(), " ");
        }
    }

    private static SummaryHost[] toHostArray(HostID ID2) throws Exception {
        return new SummaryHost[]{ID2.getByIDQuery().selectSummaryView()};
    }

    public static void write(PrintWriter pw, HostType h, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTTYPE_ID_HEADER) + ": " + h.getID());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTTYPE_NAME_HEADER) + ": " + h.getName());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTTYPE_DESCRIPTION_HEADER) + ": " + h.getDescription());
        pw.print(prefix);
        if (h.getPluginID() != null) {
            pw.println(HostUtil.toText(HOSTTYPE_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{h.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        pw.println(HostUtil.toText(HOSTTYPE_IS_HIDDEN_HEADER) + ": " + Visibility.HIDDEN.equals(h.getVisibility()));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTTYPE_ATTRIBUTES_HEADER) + ":");
        Column[] columns = new Column[]{new Column(20, 0, HostUtil.toText(HOSTTYPE_ATTRIBUTE_COLUMN)), new Column(40, 0, HostUtil.toText(HOSTTYPE_DEFAULT_COLUMN))};
        Table t = new Table(pw, columns, prefix + " ");
        HostTypeVarList vars = h.getVarList();
        String[] data = new String[2];
        for (int i = 0; i < vars.size(); ++i) {
            HostTypeVar var = vars.getVar(i);
            data[0] = var.getName();
            data[1] = var.getDefaultValue();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, HostSet h, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSET_ID_HEADER) + ": " + h.getID());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSET_NAME_HEADER) + ": " + h.getName());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSET_DESCRIPTION_HEADER) + ": " + h.getDescription());
        pw.print(prefix);
        if (h.getPluginID() != null) {
            pw.println(HostUtil.toText(HOSTSET_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{h.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        pw.println(HostUtil.toText(HOSTSET_IS_HIDDEN_HEADER) + ": " + Visibility.HIDDEN.equals(h.getVisibility()));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSET_STATIC_HOSTS_HEADER) + ":");
        HostUtil.write(pw, h.getMemberHostIDSet().getByIDsQuery().select(), " ");
        SummaryHostSet[] sets = h.getMemberHostSetIDSet().getByIDsQuery().select();
        SummaryHostSearch[] searches = h.getMemberHostSearchIDSet().getByIDsQuery().select();
        pw.println(HostUtil.toText(HOSTSET_SUBHOSTS_HEADER) + ":");
        HostUtil.write(pw, sets, " ");
        pw.println(HostUtil.toText(HOSTSET_SUBSEARCHES_HEADER) + ":");
        HostUtil.write(pw, searches, " ");
    }

    public static void write(PrintWriter pw, HostSearch h, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSEARCH_ID_HEADER) + ": " + h.getID());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSEARCH_NAME_HEADER) + ": " + h.getName());
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSEARCH_DESCRIPTION_HEADER) + ": " + h.getDescription());
        pw.print(prefix);
        if (h.getPluginID() != null) {
            pw.println(HostUtil.toText(HOSTSEARCH_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{h.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSEARCH_IS_HIDDEN_HEADER) + ": " + Visibility.HIDDEN.equals(h.getVisibility()));
        pw.print(prefix);
        pw.println(HostUtil.toText(HOSTSEARCH_QUERY_HEADER) + ":");
        pw.print(prefix + " ");
        pw.println(Context.getConverterHandler().convert(h.getCriteria().getAttributeCriteriaList(), String.class));
        pw.println(HostUtil.toText(HOSTSEARCH_FILTER_HEADER) + ":");
        pw.print(prefix + " ");
        pw.println(Context.getConverterHandler().convert(h.getCriteria().getAppTypeCriteria(), String.class));
        pw.println(HostUtil.toText(HOSTSEARCH_PHYSCRIT_HEADER) + ":");
        pw.print(prefix + " ");
        pw.println(Context.getConverterHandler().convert(h.getCriteria().getPhysicalCriteria(), String.class));
    }

    public static void write(PrintWriter pw, UIAppInstanceUpdate a, String prefix) {
        if (a.getWarning() != null) {
            pw.print(prefix);
            pw.println(HostUtil.toText(WARNING_HEADER) + ": " + a.getWarning());
        }
        HostUtil.write(pw, a.getAppInstance(), prefix);
    }

    public static void write(PrintWriter pw, AppInstance a, String prefix) {
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_ID_HEADER) + ": " + a.getID());
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_PARENT_ID_HEADER) + ": " + a.getParentID());
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_HOST_ID_HEADER) + ": " + a.getHostID());
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_TYPE_HEADER) + ": " + a.getType());
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_IP_ADDRESS_HEADER) + ": " + a.getIPAddress());
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_PORT_HEADER) + ": " + a.getPort());
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_PARAMETERS_HEADER) + ": " + a.getParameters());
        pw.print(prefix);
        pw.println(HostUtil.toText(APP_CONNECTION_HEADER) + ": " + a.getConnectionType());
    }

    public static void write(PrintWriter pw, Target t, String prefix) {
        pw.print(prefix);
        pw.println(HostUtil.toText(TARGET_ID_HEADER) + ": " + t.getID());
        pw.print(prefix);
        pw.println(HostUtil.toText(TARGET_INITIAL_NAME_HEADER) + ": " + t.getInitialHost().getName());
        pw.print(prefix);
        pw.println(HostUtil.toText(TARGET_INITIAL_ID_HEADER) + ": " + t.getInitialHostID());
        pw.print(prefix);
        pw.println(HostUtil.toText(TARGET_PHYSICAL_NAME_HEADER) + ": " + t.getPhysicalHost().getName());
        pw.print(prefix);
        pw.println(HostUtil.toText(TARGET_PHYSICAL_ID_HEADER) + ": " + t.getPhysicalHostID());
        pw.print(prefix);
        pw.println(HostUtil.toText(TARGET_CURRENT_NAME_HEADER) + ": " + t.getCurrentHost().getName());
        pw.print(prefix);
        pw.println(HostUtil.toText(TARGET_CURRENT_ID_HEADER) + ": " + t.getCurrentHostID());
    }

    public static void write(PrintWriter pw, SummaryHost[] h, String prefix) {
        HostUtil.write(pw, h, prefix, HOST_COLUMN_ID, HOST_COLUMN_NAME);
    }

    public static void write(PrintWriter pw, StandardObject[] h, String prefix, String idHeader, String nameHeader) {
        Column[] columns = new Column[]{new Column(45, 0, HostUtil.toText(idHeader)), new Column(20, 0, HostUtil.toText(nameHeader))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < h.length; ++i) {
            data[0] = h[i].getObjectID().toString();
            data[1] = h[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, SummaryHostType[] h, String prefix) {
        HostUtil.write(pw, h, prefix, HOSTTYPE_COLUMN_ID, HOSTTYPE_COLUMN_NAME);
    }

    public static void write(PrintWriter pw, SummaryHostSet[] h, String prefix) {
        HostUtil.write(pw, h, prefix, HOSTSET_COLUMN_ID, HOSTSET_COLUMN_NAME);
    }

    public static void write(PrintWriter pw, SummaryHostSearch[] h, String prefix) {
        HostUtil.write(pw, h, prefix, HOSTSEARCH_COLUMN_ID, HOSTSEARCH_COLUMN_NAME);
    }

    public static void write(PrintWriter pw, AppInstance[] a, String prefix) {
        Column[] columns = new Column[]{new Column(45, 0, HostUtil.toText(APP_COLUMN_ID)), new Column(5, 0, HostUtil.toText(APP_COLUMN_TYPE)), new Column(20, 0, HostUtil.toText(APP_COLUMN_PARAMETERS))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[3];
        for (int i = 0; i < a.length; ++i) {
            data[0] = a[i].getID().toString();
            data[1] = a[i].getType().toString();
            data[2] = a[i].getParameters();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }

    private static Object convert(Object inObj, Class cls) throws Exception {
        return Context.getConverterHandler().convert(inObj, cls);
    }
}

