/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.String2StringArray;
import com.raplix.rolloutexpress.ui.hostdbx.converters.HostIDArrayArrayBase;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostID;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostSetID;
import com.raplix.util.logger.Logger;
import java.util.Vector;

public class String2HostIDArrayArray
extends HostIDArrayArrayBase
implements Converter {
    public static final String HOST_QUALIFIER = "H:";
    public static final String HOST_SET_QUALIFIER = "HS:";

    public static HostID[][] convert(String src) throws PersistenceManagerException, PersistenceManagerException, RPCException {
        int j;
        int i;
        String2StringArray c = new String2StringArray();
        c.setDelimiters(";");
        String[] arrays = c.convert(src);
        HostID[][] result = new HostID[arrays.length][];
        c.setDelimiters(",");
        Vector<HostID> hostIDs = new Vector<HostID>();
        for (i = 0; i < arrays.length; ++i) {
            String[] strIDs = c.convert(arrays[i]);
            for (j = 0; j < strIDs.length; ++j) {
                if (strIDs[j].startsWith(HOST_QUALIFIER)) {
                    hostIDs.add(String2HostID.convert(strIDs[j].substring(HOST_QUALIFIER.length())));
                    continue;
                }
                if (!strIDs[j].startsWith(HOST_SET_QUALIFIER)) continue;
                HostSetID setID = String2HostSetID.convert(strIDs[j].substring(HOST_SET_QUALIFIER.length()));
                SummaryHost[] hosts = setID.getAllHostsQuery().selectSummaryView();
                for (int k = 0; k < hosts.length; ++k) {
                    hostIDs.add(hosts[k].getID());
                }
            }
            result[i] = hostIDs.toArray(new HostID[hostIDs.size()]);
            hostIDs.clear();
        }
        if (Logger.isDebugEnabled(String2HostIDArrayArray.class)) {
            for (i = 0; i < result.length; ++i) {
                for (j = 0; j < result[i].length; ++j) {
                    Logger.debug("[" + i + "," + j + "]=" + result[i][j], class$com$raplix$rolloutexpress$ui$hostdbx$converters$String2HostIDArrayArray == null ? String2HostIDArrayArray.class$("com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostIDArrayArray") : class$com$raplix$rolloutexpress$ui$hostdbx$converters$String2HostIDArrayArray);
                }
            }
        }
        return result;
    }
}

