/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import com.raplix.rolloutexpress.ui.hostdbx.converters.HostID2Host;
import com.raplix.rolloutexpress.ui.hostdbx.converters.PackageInfo;

public class String2Host
implements Converter,
Prefixes {
    public static Host convert(String src) throws PersistenceManagerException, RPCException {
        if ((src = src.trim()).startsWith("NM:")) {
            return String2Host.convertByName(src.substring("NM:".length()));
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return HostID2Host.convert(new HostID(src));
    }

    public static Host convertByName(String hostName) throws PersistenceManagerException, RPCException {
        Host host = null;
        try {
            host = SingleHostQuery.byName(hostName).select();
        }
        catch (NoResultsFoundException ex) {
            PackageInfo.throwNoSuchHost(hostName);
        }
        return host;
    }
}

