/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.converters;

import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ComparisonType;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.String2StringArray;
import com.raplix.rolloutexpress.ui.hostdbx.converters.AttributeCriteriaListBase;
import com.raplix.rolloutexpress.ui.hostdbx.converters.PackageInfo;
import com.raplix.util.enum.NoSuchEnumException;
import com.raplix.util.regex.GlobPattern;
import java.text.ParseException;

public class String2AttributeCriteriaList
extends AttributeCriteriaListBase
implements Converter {
    public static AttributeCriteriaList convert(String src) throws ParseException {
        String2StringArray c = new String2StringArray();
        c.setDelimiters(";");
        String[] clauses = c.convert(src);
        AttributeCriteriaList result = new AttributeCriteriaList();
        for (int i = 0; i < clauses.length; ++i) {
            String clause = clauses[i];
            char elemDelim = "-".charAt(0);
            int delim1 = clause.indexOf(elemDelim);
            if (delim1 < 0) {
                PackageInfo.throwWrongElements(clause);
            }
            String attributeName = clause.substring(0, delim1);
            int delim2 = clause.indexOf(45, delim1 + 1);
            if (delim2 < 0) {
                PackageInfo.throwWrongElements(clause);
            }
            String compTypeStr = clause.substring(delim1 + 1, delim2);
            String valStr = clause.substring(delim2 + 1);
            ComparisonType compType = null;
            try {
                compType = ComparisonType.FACTORY.get(compTypeStr);
            }
            catch (NoSuchEnumException e) {
                PackageInfo.throwUnknownComparison(compTypeStr);
            }
            GlobPattern value = GlobPattern.create(valStr);
            result.add(AttributeCriteria.create(attributeName, compType, value));
        }
        return result;
    }
}

