/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import com.raplix.rolloutexpress.ui.hostdbx.converters.PackageInfo;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2Host;
import com.raplix.util.enum.NoSuchEnumException;
import java.text.ParseException;

public class String2AppInstance
implements Converter,
Prefixes {
    public static AppInstance convert(String src) throws PersistenceManagerException, RPCException, ParseException {
        if ((src = src.trim()).startsWith("NM:")) {
            return String2AppInstance.convertByName(src.substring("NM:".length()));
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return String2AppInstance.convertByID(src);
    }

    public static AppInstance convertByID(String ID2) throws PersistenceManagerException, RPCException {
        return new AppInstanceID(ID2).getByIDQuery().select();
    }

    public static AppInstance convertByName(String name) throws PersistenceManagerException, RPCException, ParseException {
        int delimNdx = name.indexOf(58);
        if (delimNdx < 0) {
            PackageInfo.throwWrongAppInstanceElements(name);
        }
        String hostName = name.substring(0, delimNdx);
        String appType = name.substring(delimNdx + 1);
        Host h = String2Host.convertByName(hostName);
        AppType type = null;
        try {
            type = AppType.FACTORY.get(appType);
        }
        catch (NoSuchEnumException e) {
            PackageInfo.throwUnknownHostAppType(appType);
        }
        AppInstance result = h.getAppInstance(type);
        if (result == null) {
            PackageInfo.throwNoSuchAppInstance(h.getName(), appType);
        }
        return result;
    }
}

