/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.commands;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.hostdbx.commands.HostArrayContext;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class HostSetExpand
extends SessionBase {
    private static CommandHelp sHelp = new HostSetExpandHelp();
    private HostSetID mID;
    private boolean mShowHidden = false;
    private Host[] mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostSetExpand;

    public void setID(HostSetID ID2) {
        this.mID = ID2;
    }

    public HostSetID getID() {
        return this.mID;
    }

    public void setShowHidden(boolean showHidden) {
        this.mShowHidden = showHidden;
    }

    public boolean getShowHidden() {
        return this.mShowHidden;
    }

    protected void setResult(Host[] result) {
        this.mResult = result;
    }

    public Host[] getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        HostArrayContext result = (HostArrayContext)this.transactRPC(new ExecMSTransaction(this.getID(), this.getShowHidden()));
        this.setResult(result.getValue());
    }

    private static class ExecMSTransaction
    extends RPCTransaction {
        HostSetID mID;
        boolean mShowHidden;

        private ExecMSTransaction() {
        }

        ExecMSTransaction(HostSetID id, boolean showHidden) {
            super(false);
            this.mID = id;
            this.mShowHidden = showHidden;
        }

        public PersistContext executeMS() throws PersistenceManagerException {
            try {
                MultiHostQuery q = this.mID.getAllHostsQuery();
                q.setVisibilityFilter(this.mShowHidden ? null : Visibility.VISIBLE);
                return new HostArrayContext(q.select());
            }
            catch (RPCException e) {
                throw new PersistenceManagerException(e);
            }
        }
    }

    protected static class HostSetExpandHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.hdb.hs.le";
        private static final String MSG_ID_DESC = "KEY:ui.hdb.hs.le.ID_DESC";
        private static final String MSG_SHOWHIDDEN_DESC = "KEY:ui.hdb.hs.le.SHOWHIDDEN_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.hdb.hs.le.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.hdb.hs.le.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("ID", MSG_ID_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("showHidden", MSG_SHOWHIDDEN_DESC, "sh"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        HostSetExpandHelp() {
            super(class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostSetExpand == null ? (class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostSetExpand = HostSetExpand.class$("com.raplix.rolloutexpress.ui.hostdbx.commands.HostSetExpand")) : class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostSetExpand, MSG_COMMAND_DESC);
        }

        protected HostSetExpandHelp(Class helpclass, String msgCmdDesc) {
            super(helpclass, msgCmdDesc);
        }
    }
}

