/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.commands;

import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class HostQuery
extends SessionBase {
    private static CommandHelp sHelp = new HostQueryHelp();
    private AttributeCriteriaList mAttrValues;
    private AppTypeCriteria mAppTypes = new AppTypeCriteria();
    private PhysicalCriteria mPhysicalCriteria;
    private boolean mShowHidden = false;
    private Host[] mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostQuery;

    public HostQuery() {
        this.mAppTypes.reset();
    }

    public AttributeCriteriaList getAttrValues() {
        return this.mAttrValues;
    }

    public void setAttrValues(AttributeCriteriaList attrValues) {
        this.mAttrValues = attrValues;
    }

    public AppTypeCriteria getAppTypes() {
        return this.mAppTypes;
    }

    public void setAppTypes(AppTypeCriteria appTypes) {
        this.mAppTypes = appTypes;
    }

    public PhysicalCriteria getPhysicalCriteria() {
        return this.mPhysicalCriteria;
    }

    public void setPhysicalCriteria(PhysicalCriteria physicalCriteria) {
        this.mPhysicalCriteria = physicalCriteria;
    }

    public void setShowHidden(boolean showHidden) {
        this.mShowHidden = showHidden;
    }

    public boolean getShowHidden() {
        return this.mShowHidden;
    }

    protected void setResult(Host[] result) {
        this.mResult = result;
    }

    public Host[] getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        HostSearchCriteria c = new HostSearchCriteria();
        c.setAppTypeCriteria(this.getAppTypes());
        if (this.getAttrValues() != null) {
            c.setAttributeCriteriaList(this.getAttrValues());
        }
        if (this.getPhysicalCriteria() != null) {
            c.setPhysicalCriteria(this.getPhysicalCriteria());
        }
        MultiHostQuery q = c.getAllHostsQuery();
        q.setVisibilityFilter(this.getShowHidden() ? null : Visibility.VISIBLE);
        this.setResult(q.select());
    }

    protected static class HostQueryHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.hdb.h.lq";
        private static final String MSG_QUERY_DESC = "KEY:ui.hdb.h.lq.QUERY_DESC";
        private static final String MSG_APPTYPE_DESC = "KEY:ui.hdb.h.lq.APPTYPE_DESC";
        private static final String MSG_PHYSCRIT_DESC = "KEY:ui.hdb.h.lq.PHYSCRIT_DESC";
        private static final String MSG_SHOWHIDDEN_DESC = "KEY:ui.hdb.h.lq.SHOWHIDDEN_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.hdb.h.lq.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.hdb.h.lq.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.OptionalArgInfo("attrValues", MSG_QUERY_DESC, "query"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("appTypes", MSG_APPTYPE_DESC, "filt"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("physicalCriteria", MSG_PHYSCRIT_DESC, "phys"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("showHidden", MSG_SHOWHIDDEN_DESC, "sh"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        HostQueryHelp() {
            super(class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostQuery == null ? (class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostQuery = HostQuery.class$("com.raplix.rolloutexpress.ui.hostdbx.commands.HostQuery")) : class$com$raplix$rolloutexpress$ui$hostdbx$commands$HostQuery, MSG_COMMAND_DESC);
        }
    }
}

