/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.commands;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.ui.hostdbx.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Hashtable;
import java.util.Iterator;

public abstract class HostEditBase
extends SessionBase {
    private String mName;
    private HostTypeID mTypeID;
    private String mDescription;
    private Hashtable mAttributes;
    private Boolean mIsHidden;
    private HostID mParentHostID;
    private boolean mParentHostIDSet = false;

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setTypeID(HostTypeID typeID) {
        this.mTypeID = typeID;
    }

    public HostTypeID getTypeID() {
        return this.mTypeID;
    }

    public void setAttributes(Hashtable attributes) {
        this.mAttributes = attributes;
    }

    public Hashtable getAttributes() {
        return this.mAttributes;
    }

    public void setIsHidden(Boolean isHidden) {
        this.mIsHidden = isHidden;
    }

    public Boolean getIsHidden() {
        return this.mIsHidden;
    }

    public void setParentHostID(HostID parentID) {
        this.mParentHostID = parentID;
        this.mParentHostIDSet = true;
    }

    public HostID getParentHostID() {
        return this.mParentHostID;
    }

    protected void setHost(Host h) throws RaplixException {
        if (this.getName() != null) {
            h.setName(this.getName());
        }
        if (this.getDescription() != null) {
            h.setDescription(this.getDescription());
        }
        if (this.getTypeID() != null) {
            h.setHostType(this.getTypeID().getByIDQuery().select());
        }
        if (this.getIsHidden() != null) {
            h.setVisibility(this.getIsHidden() != false ? Visibility.HIDDEN : Visibility.VISIBLE);
        }
        if (this.mParentHostIDSet) {
            try {
                h.setParentHostID(this.getParentHostID());
            }
            catch (UnsupportedOperationException e) {
                PackageInfo.throwCantModVirtualHostParent();
            }
        }
        if (this.getAttributes() != null) {
            h.removeAllOverrideVarValues();
            Hashtable attrs = this.getAttributes();
            Iterator keys = attrs.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                h.setOverrideVarValue(key, (String)attrs.get(key));
            }
        }
    }
}

