/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.commands;

import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;

public abstract class AppEditBase
extends SessionBase {
    private AppInstanceID mParentID;
    private String mIpAddress;
    private Integer mPort;
    private ConnectionType mConnectionType;
    private String mParameters;

    public void setParentID(AppInstanceID parentID) {
        this.mParentID = parentID;
    }

    public AppInstanceID getParentID() {
        return this.mParentID;
    }

    public void setIpAddress(String ipAddress) {
        this.mIpAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.mIpAddress;
    }

    public void setPort(Integer port) {
        this.mPort = port;
    }

    public Integer getPort() {
        return this.mPort;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.mConnectionType = connectionType;
    }

    public ConnectionType getConnectionType() {
        return this.mConnectionType;
    }

    public void setParameters(String parameters) {
        this.mParameters = parameters;
    }

    public String getParameters() {
        return this.mParameters;
    }

    protected void setAppInstance(AppInstance app) throws TransportException {
        String ip;
        int port;
        if (this.getConnectionType() != null) {
            app.setConnectionType(this.getConnectionType());
        }
        boolean setAddr = false;
        if (this.getPort() != null) {
            setAddr = true;
            port = this.getPort();
        } else {
            port = app.getPort();
        }
        if (port == 0 && ConnectionType.SSH.equals(app.getConnectionType())) {
            setAddr = true;
            port = app.getType().getDefaultSSHPort();
        }
        if (this.getIpAddress() != null) {
            setAddr = true;
            ip = this.getIpAddress();
        } else {
            ip = app.getIPAddress();
        }
        if (setAddr) {
            app.setRoxAddress(new RoxAddress(ip, port));
        }
        if (this.getParameters() != null) {
            app.setParameters(this.getParameters());
        }
        if (this.getParentID() != null) {
            app.setParentID(this.getParentID());
        }
    }
}

