/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.hostdbx.commands;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.transport.config.TransportConfigUpdateFailure;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.hostdbx.commands.AppEditBase;
import com.raplix.rolloutexpress.ui.hostdbx.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.hostdbx.converters.UIAppInstanceUpdate;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class AppAdd
extends AppEditBase {
    private static CommandHelp sHelp = new AppAddHelp();
    private HostID mHostID;
    private AppType mType;
    private UIAppInstanceUpdate mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$hostdbx$commands$AppAdd;

    public void setHostID(HostID hostID) {
        this.mHostID = hostID;
    }

    public HostID getHostID() {
        return this.mHostID;
    }

    public void setType(AppType type) throws RaplixException {
        if (AppType.MS.equals(type)) {
            PackageInfo.throwMSTagIllegalForApps();
        } else {
            this.mType = type;
        }
    }

    public AppType getType() {
        return this.mType;
    }

    protected void setResult(UIAppInstanceUpdate result) {
        this.mResult = result;
    }

    public UIAppInstanceUpdate getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        AppInstance a = new AppInstance(this.getType());
        this.setAppInstance(a);
        Host h = this.getHostID().getByIDQuery().select();
        h.addAppInstance(a);
        String warning = null;
        try {
            h.save();
        }
        catch (TransportConfigUpdateFailure tcuf) {
            warning = tcuf.getMessage();
        }
        this.setResult(new UIAppInstanceUpdate(h.getAppInstance(a.getType()), warning));
    }

    protected static class AppAddHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.hdb.a.add";
        private static final String MSG_HOSTID_DESC = "KEY:ui.hdb.a.add.HOSTID_DESC";
        private static final String MSG_TYPE_DESC = "KEY:ui.hdb.a.add.TYPE_DESC";
        private static final String MSG_PARENTID_DESC = "KEY:ui.hdb.a.add.PARENTID_DESC";
        private static final String MSG_IPADDRESS_DESC = "KEY:ui.hdb.a.add.IPADDRESS_DESC";
        private static final String MSG_PORT_DESC = "KEY:ui.hdb.a.add.PORT_DESC";
        private static final String MSG_CONNECTIONTYPE_DESC = "KEY:ui.hdb.a.add.CONNECTIONTYPE_DESC";
        private static final String MSG_PARAMETERS_DESC = "KEY:ui.hdb.a.add.PARAMETERS_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.hdb.a.add.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.hdb.a.add.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("hostID", MSG_HOSTID_DESC, "hID"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("type", MSG_TYPE_DESC));
            map.addElement(new CommandHelpBase.RequiredArgInfo("parentID", MSG_PARENTID_DESC, "pID"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("ipAddress", MSG_IPADDRESS_DESC, "ip"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("port", MSG_PORT_DESC));
            map.addElement(new CommandHelpBase.RequiredArgInfo("connectionType", MSG_CONNECTIONTYPE_DESC, "conn"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("parameters", MSG_PARAMETERS_DESC, "param"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        AppAddHelp() {
            super(class$com$raplix$rolloutexpress$ui$hostdbx$commands$AppAdd == null ? (class$com$raplix$rolloutexpress$ui$hostdbx$commands$AppAdd = AppAdd.class$("com.raplix.rolloutexpress.ui.hostdbx.commands.AppAdd")) : class$com$raplix$rolloutexpress$ui$hostdbx$commands$AppAdd, MSG_COMMAND_DESC);
        }
    }
}

