/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.formatters;

import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.formatters.PackageInfo;
import com.raplix.util.file.XSLTUtil;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTFormatter
implements Formatter {
    private Transformer mTransformer;

    public XSLTFormatter(Transformer transformer) {
        this.mTransformer = transformer;
    }

    public XSLTFormatter(String resourceName) {
        InputStream stream = XSLTFormatter.class.getResourceAsStream("/" + resourceName);
        if (stream == null) {
            PackageInfo.throwTransformerNotFound(resourceName);
        }
        this.mTransformer = XSLTUtil.getTransformer(new StreamSource(stream));
    }

    public void write(Object src, OutputStream out) throws Exception {
        XSLTUtil.transform(this.mTransformer, new StreamSource((InputStream)src), new StreamResult(out));
    }
}

