/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.formatters;

import [Lcom.raplix.util.table.Column;;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.converters.String2Integer;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.file.XMLUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TableFormatter
implements Formatter {
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_ALIGN = "align";
    private static final String VAL_ALIGN_LEFT = "left";
    private static final String VAL_ALIGN_CENTER = "center";
    private static final String VAL_ALIGN_RIGHT = "right";
    private static final int DEFAULT_WIDTH = 10;
    private static final int DEFAULT_ALIGN = 0;
    private DocumentBuilder mBuilder = XMLUtil.getDocumentBuilder();

    public void write(Object src, OutputStream out) throws Exception {
        DOMElementEnumeration e = new DOMElementEnumeration(this.mBuilder.parse((InputStream)src).getFirstChild());
        PrintWriter pw = new PrintWriter(out);
        Vector<Column> columns = new Vector<Column>();
        DOMElementEnumeration eh = new DOMElementEnumeration(e.nextElement());
        while (eh.hasMoreElements()) {
            Element header = eh.nextElement();
            NamedNodeMap attr = header.getAttributes();
            int width = 10;
            Node widthNode = attr.getNamedItem(ATTR_WIDTH);
            if (widthNode != null) {
                width = String2Integer.convert(widthNode.getNodeValue());
            }
            Node alignNode = attr.getNamedItem(ATTR_ALIGN);
            int align = 0;
            if (alignNode != null) {
                align = VAL_ALIGN_LEFT.equals(alignNode.getNodeValue()) ? 0 : (VAL_ALIGN_RIGHT.equals(alignNode.getNodeValue()) ? 2 : 1);
            }
            columns.addElement(new Column(width, align, header.getFirstChild().getNodeValue()));
        }
        Table t = new Table(pw, (Column[])CollectionUtil.mapClass(columns, Column;.class));
        String[] data = new String[columns.size()];
        while (e.hasMoreElements()) {
            int i = 0;
            DOMElementEnumeration ev = new DOMElementEnumeration(e.nextElement());
            while (ev.hasMoreElements()) {
                data[i++] = ev.nextElement().getFirstChild().getNodeValue();
            }
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
        pw.flush();
    }
}

