/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.formatters;

import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.formatters.PackageInfo;
import com.raplix.rolloutexpress.ui.formatters.RawFormatter;
import com.raplix.rolloutexpress.ui.formatters.SerialFormatter;
import com.raplix.rolloutexpress.ui.formatters.SinkFormatter;
import com.raplix.rolloutexpress.ui.formatters.StringFormatter;
import com.raplix.rolloutexpress.ui.formatters.TableFormatter;
import com.raplix.rolloutexpress.ui.formatters.XSLTFormatter;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.logger.Logger;
import com.raplix.util.reflect.ClassUtil;
import com.raplix.util.string.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FormatterRepository {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String VAL_TYPE_SINK = "sink";
    private static final String VAL_TYPE_RAW = "raw";
    private static final String VAL_TYPE_SERIALIZED = "serialized";
    private static final String VAL_TYPE_STRING = "string";
    private static final String VAL_TYPE_XSLT = "xslt";
    private static final String VAL_TYPE_TABLE = "table";
    private static final String VAL_TYPE_CLASS = "class";
    private static final String ATTR_TRANSFORM = "transform";
    private static final String ATTR_CLASS = "class";
    private Hashtable mMap = new Hashtable();
    private String mDefaultFormatterName = "sink";

    public void setDefaultFormatterName(String name) {
        this.mDefaultFormatterName = name;
    }

    public String getDefaultFormatterName() {
        return this.mDefaultFormatterName;
    }

    private void addFormatter(Node node) {
        NamedNodeMap attr = node.getAttributes();
        String type = attr.getNamedItem(ATTR_TYPE).getNodeValue();
        String name = attr.getNamedItem(ATTR_NAME).getNodeValue();
        if (VAL_TYPE_SINK.equals(type)) {
            this.addFormatter(name, new SinkFormatter());
            return;
        }
        if (VAL_TYPE_RAW.equals(type)) {
            this.addFormatter(name, new RawFormatter());
            return;
        }
        if (VAL_TYPE_STRING.equals(type)) {
            this.addFormatter(name, new StringFormatter());
            return;
        }
        if ("class".equals(type)) {
            this.addFormatter(name, (Formatter)ClassUtil.createObject(attr.getNamedItem("class").getNodeValue(), Formatter.class));
            return;
        }
        if (VAL_TYPE_XSLT.equals(type)) {
            SerialFormatter f = new SerialFormatter();
            f.addFormatter(Context.getSerializer());
            f.addFormatter(new XSLTFormatter(attr.getNamedItem(ATTR_TRANSFORM).getNodeValue()));
            this.addFormatter(name, f);
            return;
        }
        if (VAL_TYPE_TABLE.equals(type)) {
            SerialFormatter f = new SerialFormatter();
            f.addFormatter(Context.getSerializer());
            f.addFormatter(new XSLTFormatter(attr.getNamedItem(ATTR_TRANSFORM).getNodeValue()));
            f.addFormatter(new TableFormatter());
            this.addFormatter(name, f);
        }
    }

    public void addFormatter(String name, Formatter formatter) {
        this.mMap.put(name, formatter);
    }

    public void addFormatters(Node node) {
        DOMElementEnumeration e = new DOMElementEnumeration(node);
        while (e.hasMoreElements()) {
            this.addFormatter(e.nextElement());
        }
    }

    public void addDefaultFormatters() {
        if (this.mMap.get(VAL_TYPE_SINK) == null) {
            this.addFormatter(VAL_TYPE_SINK, new SinkFormatter());
        }
        if (this.mMap.get(VAL_TYPE_RAW) == null) {
            this.addFormatter(VAL_TYPE_RAW, new RawFormatter());
        }
        if (this.mMap.get(VAL_TYPE_STRING) == null) {
            this.addFormatter(VAL_TYPE_STRING, new StringFormatter());
        }
        if (this.mMap.get(VAL_TYPE_SERIALIZED) == null) {
            this.addFormatter(VAL_TYPE_SERIALIZED, Context.getSerializer());
        }
    }

    public Formatter getFormatter(String name) {
        Formatter f;
        if (name == null) {
            name = this.getDefaultFormatterName();
        }
        if ((f = (Formatter)this.mMap.get(name)) != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Retrieved formatter '" + name + "'", this);
            }
            return f;
        }
        PackageInfo.throwFormatterNotFound(name);
        return null;
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<formatters>");
        buffer.append(StringUtil.LINE_SEPARATOR);
        Enumeration e = this.mMap.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            buffer.append("<formatter default=\"");
            buffer.append(name.equals(this.getDefaultFormatterName()) ? "true" : "false");
            buffer.append("\">");
            buffer.append(name);
            buffer.append("</formatter>");
            buffer.append(StringUtil.LINE_SEPARATOR);
        }
        buffer.append("</formatters>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Formatters:" + StringUtil.LINE_SEPARATOR + " ");
        Enumeration e = this.mMap.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals(this.getDefaultFormatterName())) {
                buffer.append('*');
                buffer.append(name);
                buffer.append('*');
            } else {
                buffer.append(name);
            }
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

