/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.folderdb.formatters;

import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionItem;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.plugindb.formatters.PluginUtil;
import com.raplix.rolloutexpress.ui.userdb.converters.GroupID2Group;
import com.raplix.rolloutexpress.ui.userdb.formatters.UserUtil;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.string.StringUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;
import java.util.Iterator;

public final class FolderUtil {
    private static final String FOLDER_FORMAT_PREFIX = "ui.fdb.format.f.";
    private static final String FOLDER_ID_HEADER = "ui.fdb.format.f.ID_HEADER";
    private static final String FOLDER_NAME_HEADER = "ui.fdb.format.f.NAME_HEADER";
    private static final String FOLDER_DESCRIPTION_HEADER = "ui.fdb.format.f.DESCRIPTION_HEADER";
    private static final String FOLDER_GROUP_OWNER_HEADER = "ui.fdb.format.f.GROUP_OWNER_HEADER";
    private static final String FOLDER_GROUP_PERMISSIONS_HEADER = "ui.fdb.format.f.GROUP_PERMISSIONS_HEADER";
    private static final String GROUP_HEADER = "ui.fdb.format.f.GROUP_HEADER";
    private static final String WRITE_PERMISSION_HEADER = "ui.fdb.format.f.WRITE_PERMISSION_HEADER";
    private static final String AUTORUN_PERMISSION_HEADER = "ui.fdb.format.f.AUTORUN_PERMISSION_HEADER";
    private static final String CHECKIN_PERMISSION_HEADER = "ui.fdb.format.f.CHECKIN_PERMISSION_HEADER";
    private static final String EXECUTE_PERMISSION_HEADER = "ui.fdb.format.f.EXECUTE_PERMISSION_HEADER";
    private static final String FOLDER_FROM_PLUGIN_HEADER = "ui.fdb.format.f.FROM_PLUGIN_HEADER";
    private static final String DELETE_HISTORY_PERMISSION_HEADER = "ui.fdb.format.f.DELETE_HISTORY_PERMISSION_HEADER";
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$userdb$Group;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$hostdbx$HostSet;

    private FolderUtil() {
    }

    public static void write(PrintWriter pw, Folder f, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(FolderUtil.toText(FOLDER_ID_HEADER) + ": " + f.getID());
        pw.print(prefix);
        pw.println(FolderUtil.toText(FOLDER_NAME_HEADER) + ": " + f.getFullPathString());
        pw.print(prefix);
        pw.println(FolderUtil.toText(FOLDER_GROUP_OWNER_HEADER) + ": ");
        UserUtil.detailedWrite(pw, new Group[]{GroupID2Group.convert(f.getGroupID())}, prefix + " ");
        pw.print(prefix);
        pw.println(FolderUtil.toText(FOLDER_DESCRIPTION_HEADER) + ": " + StringUtil.normalizeEmpty(f.getDescription()));
        if (f.getPluginID() != null) {
            pw.println(FolderUtil.toText(FOLDER_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{f.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        pw.print(prefix);
        pw.println(FolderUtil.toText(FOLDER_GROUP_PERMISSIONS_HEADER) + ": ");
        FolderUtil.detailedWrite(pw, f.getFolderAccessData(), prefix + " ");
    }

    public static void write(PrintWriter pw, SummaryFolder[] folders, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, FolderUtil.toText(FOLDER_ID_HEADER)), new Column(45, 0, FolderUtil.toText(FOLDER_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[columns.length];
        for (int i = 0; i < folders.length; ++i) {
            data[0] = folders[i].getID().toString();
            data[1] = folders[i].getFullPathString();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void detailedWrite(PrintWriter pw, FolderAccessData fad, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(15, 0, FolderUtil.toText(GROUP_HEADER)), new Column(10, 0, FolderUtil.toText(WRITE_PERMISSION_HEADER)), new Column(10, 0, FolderUtil.toText(AUTORUN_PERMISSION_HEADER)), new Column(10, 0, FolderUtil.toText(CHECKIN_PERMISSION_HEADER)), new Column(25, 0, FolderUtil.toText(EXECUTE_PERMISSION_HEADER)), new Column(25, 0, FolderUtil.toText(DELETE_HISTORY_PERMISSION_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[columns.length];
        Iterator groups = fad.getACLGroups().iterator();
        while (groups.hasNext()) {
            HostSet hostSet;
            GroupID groupID = (GroupID)groups.next();
            FolderPermissionItem fpi = fad.getACL(groupID);
            Group group = (Group)FolderUtil.convert(groupID, class$com$raplix$rolloutexpress$systemmodel$userdb$Group == null ? FolderUtil.class$("com.raplix.rolloutexpress.systemmodel.userdb.Group") : class$com$raplix$rolloutexpress$systemmodel$userdb$Group);
            String hostSetName = "";
            String deleteHistoryHostSetName = "";
            if (fpi.getExecute() != null) {
                hostSet = (HostSet)FolderUtil.convert(fpi.getExecute(), class$com$raplix$rolloutexpress$systemmodel$hostdbx$HostSet == null ? FolderUtil.class$("com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet") : class$com$raplix$rolloutexpress$systemmodel$hostdbx$HostSet);
                hostSetName = hostSet.getName();
            } else if (fpi.isExecuteAllHosts()) {
                hostSetName = "allhosts";
            }
            if (fpi.getDeleteHistory() != null) {
                hostSet = (HostSet)FolderUtil.convert(fpi.getDeleteHistory(), class$com$raplix$rolloutexpress$systemmodel$hostdbx$HostSet == null ? FolderUtil.class$("com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet") : class$com$raplix$rolloutexpress$systemmodel$hostdbx$HostSet);
                deleteHistoryHostSetName = hostSet.getName();
            } else if (fpi.isDeleteHistoryAllHosts()) {
                deleteHistoryHostSetName = "allhosts";
            }
            data[0] = group.getName();
            data[1] = Boolean.toString(fpi.isWrite());
            data[2] = Boolean.toString(fpi.isAutoRun());
            data[3] = Boolean.toString(fpi.isCheckin());
            data[4] = hostSetName;
            data[5] = deleteHistoryHostSetName;
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }

    private static Object convert(Object inObj, Class cls) throws Exception {
        return Context.getConverterHandler().convert(inObj, cls);
    }
}

