/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.folderdb.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import com.raplix.rolloutexpress.ui.folderdb.converters.FolderID2Folder;
import com.raplix.rolloutexpress.ui.folderdb.converters.PackageInfo;

public class String2Folder
implements Converter,
Prefixes {
    public static Folder convert(String src) throws PersistenceManagerException, RPCException {
        if ((src = src.trim()).startsWith("NM:")) {
            return String2Folder.convertByName(src.substring("NM:".length()));
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return FolderID2Folder.convert(new FolderID(src));
    }

    public static Folder convertByName(String folderName) throws PersistenceManagerException, RPCException {
        Folder folder = null;
        try {
            folder = SingleFolderQuery.byPath(folderName).select();
        }
        catch (NoResultsFoundException ex) {
            PackageInfo.throwNoSuchFolder(folderName);
        }
        return folder;
    }
}

