/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.folderdb.commands;

import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionItem;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.folderdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostSetID;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class FolderModifyPermissions
extends SessionBase {
    private static final CommandHelp sHelp = new FolderModifyPermissionsHelp();
    private FolderID mID;
    private GroupID mGroupID;
    private Boolean mWrite;
    private Boolean mCheckin;
    private String mHostSetID;
    private Boolean mAutoRun;
    private Folder mResult;
    private String mDeleteHistoryHostSetID;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderModifyPermissions;

    public void setID(FolderID ID2) {
        this.mID = ID2;
    }

    public FolderID getID() {
        return this.mID;
    }

    public void setGroupID(GroupID ID2) {
        this.mGroupID = ID2;
    }

    public GroupID getGroupID() {
        return this.mGroupID;
    }

    public void setWrite(Boolean write) {
        this.mWrite = write;
    }

    public Boolean getWrite() {
        return this.mWrite;
    }

    public void setCheckin(Boolean checkin) {
        this.mCheckin = checkin;
    }

    public Boolean getCheckin() {
        return this.mCheckin;
    }

    public void setExecute(String hostSetID) {
        this.mHostSetID = hostSetID;
    }

    public String getExecute() {
        return this.mHostSetID;
    }

    public void setDelete(String hostSetID) {
        this.mDeleteHistoryHostSetID = hostSetID;
    }

    public String getDelete() {
        return this.mDeleteHistoryHostSetID;
    }

    public void setAutoRun(Boolean autoRun) {
        this.mAutoRun = autoRun;
    }

    public Boolean getAutoRun() {
        return this.mAutoRun;
    }

    protected void setResult(Folder result) {
        this.mResult = result;
    }

    public Folder getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        if (Boolean.TRUE.equals(this.mWrite) && (Boolean.FALSE.equals(this.mCheckin) || Boolean.FALSE.equals(this.mAutoRun))) {
            throw PackageInfo.createInvalidArgument();
        }
        Folder f = this.getID().getByIDQuery().select();
        FolderAccessData fad = f.getFolderAccessData();
        if (!(this.mWrite != null && !this.mWrite.equals(Boolean.FALSE) || this.mCheckin != null && !this.mCheckin.equals(Boolean.FALSE) || this.mAutoRun != null && !this.mAutoRun.equals(Boolean.FALSE) || this.mHostSetID != null || this.mDeleteHistoryHostSetID != null)) {
            fad.removeACL(this.mGroupID);
        } else {
            FolderPermissionItem fpi = new FolderPermissionItem(this.mGroupID);
            if (this.mWrite != null) {
                fpi.setWrite(this.mWrite);
            }
            if (this.mCheckin != null) {
                fpi.setCheckin(this.mCheckin);
            }
            if (this.mAutoRun != null) {
                fpi.setAutoRun(this.mAutoRun);
            }
            if (this.mHostSetID != null) {
                if (this.mHostSetID.equals("allhosts")) {
                    fpi.setExecuteAllHosts(true);
                } else {
                    fpi.setExecute(String2HostSetID.convert(this.mHostSetID));
                }
            }
            if (this.mDeleteHistoryHostSetID != null) {
                if (this.mDeleteHistoryHostSetID.equals("allhosts")) {
                    fpi.setDeleteHistoryAllHosts(true);
                } else {
                    fpi.setDeleteHistory(String2HostSetID.convert(this.mDeleteHistoryHostSetID));
                }
            }
            fad.addACL(fpi);
        }
        f.setFolderAccessData(fad);
        f.save();
        this.setResult(f);
    }

    protected static class FolderModifyPermissionsHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.fdb.f.mp";
        private static final String MSG_ID_DESC = "KEY:ui.fdb.f.mp.ID_DESC";
        private static final String MSG_GROUP_ID_DESC = "KEY:ui.fdb.f.mp.GROUP_ID_DESC";
        private static final String MSG_WRITE_DESC = "KEY:ui.fdb.f.mp.WRITE_DESC";
        private static final String MSG_CHECKIN_CURRENT_DESC = "KEY:ui.fdb.f.mp.CHECKIN_CURRENT_DESC";
        private static final String MSG_AUTORUN_DESC = "KEY:ui.fdb.f.mp.AUTORUN_DESC";
        private static final String MSG_EXECUTE_DESC = "KEY:ui.fdb.f.mp.EXECUTE_DESC";
        private static final String MSG_DELETE_HISTORY_DESC = "KEY:ui.fdb.f.mp.DELETE_HISTORY_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.fdb.f.mp.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.fdb.f.mp.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("ID", MSG_ID_DESC));
            map.addElement(new CommandHelpBase.RequiredArgInfo("groupID", MSG_GROUP_ID_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("write", MSG_WRITE_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("checkin", MSG_CHECKIN_CURRENT_DESC, "checkin-current"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("autoRun", MSG_AUTORUN_DESC, "autorun"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("execute", MSG_EXECUTE_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("delete", MSG_DELETE_HISTORY_DESC, "delete-history"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        FolderModifyPermissionsHelp() {
            super(class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderModifyPermissions == null ? (class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderModifyPermissions = FolderModifyPermissions.class$("com.raplix.rolloutexpress.ui.folderdb.commands.FolderModifyPermissions")) : class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderModifyPermissions, MSG_COMMAND_DESC);
        }
    }
}

