/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.folderdb.commands;

import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.folderdb.commands.FolderEditBase;
import com.raplix.rolloutexpress.ui.folderdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.rolloutexpress.ui.web.Util;
import java.util.Vector;

public class FolderAdd
extends FolderEditBase {
    private static CommandHelp sHelp = new FolderAddHelp();
    private Folder mResult;
    private boolean mParents = false;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderAdd;

    protected void setResult(Folder result) {
        this.mResult = result;
    }

    public Folder getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        String parentFolderString;
        SingleFolderQuery sfq;
        if (!this.getFullname().startsWith("/")) {
            PackageInfo.throwFwdSlashRequired();
        }
        if (!(sfq = SingleFolderQuery.byPath(parentFolderString = Util.fullNameToPath(this.getFullname()))).selectExists() && this.mParents) {
            Folder.createPath(parentFolderString);
        }
        Folder parentFolder = sfq.select();
        Folder f = new Folder(Util.fullNameToShortName(this.getFullname()), parentFolder.getID(), null);
        this.setFolder(f);
        f.save();
        this.setResult(f);
    }

    public boolean getParents() {
        return this.mParents;
    }

    public void setParents(boolean parents) {
        this.mParents = parents;
    }

    protected static class FolderAddHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.fdb.f.add";
        private static final String MSG_NAME_DESC = "KEY:ui.fdb.f.add.NAME_DESC";
        private static final String MSG_DESCRIPTION_DESC = "KEY:ui.fdb.f.add.DESCRIPTION_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.fdb.f.add.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.fdb.f.add.COMMAND_DESC";
        private static final String MSG_PARENTS_DESC = "KEY:ui.fdb.f.add.PARENTS_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("fullname", MSG_NAME_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("description", MSG_DESCRIPTION_DESC, "desc"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("parents", MSG_PARENTS_DESC, "parents"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        FolderAddHelp() {
            super(class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderAdd == null ? (class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderAdd = FolderAdd.class$("com.raplix.rolloutexpress.ui.folderdb.commands.FolderAdd")) : class$com$raplix$rolloutexpress$ui$folderdb$commands$FolderAdd, MSG_COMMAND_DESC);
        }
    }
}

