/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.executor.formatters;

import [Lcom.raplix.rolloutexpress.config.GeneratedVariableSettings;;
import [Lcom.raplix.rolloutexpress.systemmodel.componentdb.Component;;
import [Lcom.raplix.rolloutexpress.systemmodel.hostdbx.Host;;
import [Lcom.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;;
import [Lcom.raplix.rolloutexpress.systemmodel.userdb.User;;
import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.userdb.User;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.componentdb.formatters.ComponentDBUtil;
import com.raplix.rolloutexpress.ui.converters.TimeInterval;
import com.raplix.rolloutexpress.ui.hostdbx.formatters.HostUtil;
import com.raplix.rolloutexpress.ui.plandb.formatters.PlanDBUtil;
import com.raplix.rolloutexpress.ui.rule.converters.HostStatus2String;
import com.raplix.rolloutexpress.ui.userdb.formatters.UserUtil;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;
import java.util.Date;

public final class ExecutorUtil {
    private static final String TASK_INFO_FORMAT_PREFIX = "ui.pe.format.ti.";
    private static final String TASK_INFO_ID_HEADER = "ui.pe.format.ti.ID_HEADER";
    private static final String TASK_INFO_PERFORM_DETAILED_PREFLIGHT_HEADER = "ui.pe.format.ti.PERFORM_DETAILED_PREFLIGHT_HEADER";
    private static final String TASK_INFO_HOSTS_RUNNING_LIMIT = "ui.pe.format.ti.HOSTS_RUNNING_LIMIT_HEADER";
    private static final String TASK_INFO_EXEC_PLAN_HEADER = "ui.pe.format.ti.EXEC_PLAN_HEADER";
    private static final String TASK_INFO_IS_PREFLIGHT_HEADER = "ui.pe.format.ti.IS_PREFLIGHT_HEADER";
    private static final String TASK_INFO_RUNNER_HEADER = "ui.pe.format.ti.RUNNER_HEADER";
    private static final String TASK_INFO_PLAN_TIMEOUT_HEADER = "ui.pe.format.ti.PLAN_TIMEOUT_HEADER";
    private static final String TASK_INFO_NATIVE_CALL_TIMEOUT_HEADER = "ui.pe.format.ti.NATIVE_CALL_TIMEOUT_HEADER";
    private static final String TASK_INFO_SUBPLAN_PROMPTS_HEADER = "ui.pe.format.ti.SUBPLAN_PROMPTS_HEADER";
    private static final String TASK_INFO_TARGET_STATUS_HEADER = "ui.pe.format.ti.TARGET_STATUS_HEADER";
    private static final String SUBPLAN_PROMPT_FORMAT_PREFIX = "ui.pe.format.sp.";
    private static final String SUBPLAN_PROMPT_INDEX_HEADER = "ui.pe.format.sp.INDEX_HEADER";
    private static final String SUBPLAN_PROMPT_ID_HEADER = "ui.pe.format.sp.ID_HEADER";
    private static final String SUBPLAN_PROMPT_NAME_HEADER = "ui.pe.format.sp.NAME_HEADER";
    private static final String SUBPLAN_PROMPT_TARGETS_HEADER = "ui.pe.format.sp.TARGETS_HEADER";
    private static final String SUBPLAN_PROMPT_COMPANDVARS_HEADER = "ui.pe.format.sp.COMPANDVARS_HEADER";
    private static final String TARGET_STATUS_FORMAT_PREFIX = "ui.pe.format.hs.";
    private static final String TARGET_STATUS_ID_HEADER = "ui.pe.format.hs.ID_HEADER";
    private static final String TARGET_STATUS_NAME_HEADER = "ui.pe.format.hs.NAME_HEADER";
    private static final String TARGET_STATUS_STATUS_HEADER = "ui.pe.format.hs.STATUS_HEADER";
    private static final String RUNNING_PLAN_FORMAT_PREFIX = "ui.pe.format.rp.";
    private static final String RUNNING_PLAN_TASKID_HEADER = "ui.pe.format.rp.TASKID_HEADER";
    private static final String RUNNING_PLAN_STARTEDENDED_HEADER = "ui.pe.format.rp.STARTEDENDED_HEADER";
    private static final String RUNNING_PLAN_LIVE_HEADER = "ui.pe.format.rp.LIVE_HEADER";
    private static final String EXEC_NATIVE_OUTPUT_FORMAT_PREFIX = "ui.pe.format.eno.";
    private static final String EXEC_NATIVE_OUTPUT_STDOUT_HEADER = "ui.pe.format.eno.STDOUT_HEADER";
    private static final String EXEC_NATIVE_OUTPUT_STDERR_HEADER = "ui.pe.format.eno.STDERR_HEADER";
    private static final String EXEC_NATIVE_OUTPUT_EXIT_CODE_HEADER = "ui.pe.format.eno.EXIT_CODE_HEADER";
    private static final String STEP_FORMAT_PREFIX = "ui.pe.format.st.";
    private static final String STEP_ID_HEADER = "ui.pe.format.st.STEPID_HEADER";
    private static final String NONE = "ui.pe.format.NONE";
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$hostdbx$Host;

    private ExecutorUtil() {
    }

    public static void write(PrintWriter pw, TaskInfo t, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_ID_HEADER) + ": " + t.getTaskID());
        ExecutorUtil.summaryWrite(pw, t, prefix);
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_PERFORM_DETAILED_PREFLIGHT_HEADER) + ": " + t.getDetailedPreflight());
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_HOSTS_RUNNING_LIMIT) + ": " + t.getPlanThrottle());
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_PLAN_TIMEOUT_HEADER) + ": " + ExecutorUtil.secs2String(t.getPlanTimeoutSecs()));
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_NATIVE_CALL_TIMEOUT_HEADER) + ": " + ExecutorUtil.secs2String(t.getNativeCallTimeoutSecs()));
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_SUBPLAN_PROMPTS_HEADER) + ":");
        ExecutorUtil.write(pw, t.getSubplanInfos(), prefix + " ");
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_TARGET_STATUS_HEADER) + ":");
        ExecutorUtil.write(pw, ExecutorUtil.getTargetStatus(t), prefix + " ");
    }

    private static TargetStatus[] getTargetStatus(TaskInfo t) throws PlanExecutionException {
        return t.getAllTargetsStatus();
    }

    public static void summaryWrite(PrintWriter pw, TaskInfo t, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_EXEC_PLAN_HEADER) + ":");
        ExecutorUtil.write(pw, t.getPlanID(), prefix + " ");
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_IS_PREFLIGHT_HEADER) + ": " + TaskExecutor.isPreflightRunLevel(t.getRunLevel()));
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(TASK_INFO_RUNNER_HEADER) + ":");
        ExecutorUtil.write(pw, t.getRoxUser(), prefix + " ");
    }

    public static void write(PrintWriter pw, SubplanInfo[] a, String prefix) throws Exception {
        if (a == null || a.length == 0) {
            pw.println(prefix + ExecutorUtil.toText(NONE));
        }
        for (int i = 0; i < a.length; ++i) {
            pw.print(prefix);
            pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_INDEX_HEADER) + ": " + (i + 1));
            ExecutorUtil.write(pw, a[i], prefix + " ");
        }
    }

    public static void write(PrintWriter pw, SubplanInfo p, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_ID_HEADER) + ": " + p.getSubplanID());
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_NAME_HEADER) + ": " + p.getSubplanName());
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_TARGETS_HEADER) + ":");
        ExecutorUtil.write(pw, p.getInitialHostIDs(), prefix + " ");
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_COMPANDVARS_HEADER) + ":");
        ExecutorUtil.write(pw, p.getComponentIDs(), p.getGeneratedVariableSettingsIDs(), prefix + " ");
    }

    public static void write(PrintWriter pw, SubplanPrompt[] a, String prefix) throws Exception {
        if (a == null || a.length == 0) {
            pw.println(prefix + ExecutorUtil.toText(NONE));
        }
        for (int i = 0; i < a.length; ++i) {
            pw.print(prefix);
            pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_INDEX_HEADER) + ": " + (i + 1));
            ExecutorUtil.write(pw, a[i], prefix + " ");
        }
    }

    public static void write(PrintWriter pw, SubplanPrompt p, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_ID_HEADER) + ": " + p.getSubplanID());
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_NAME_HEADER) + ": " + p.getSubplanName());
        pw.print(prefix);
        pw.println(ExecutorUtil.toText(SUBPLAN_PROMPT_COMPANDVARS_HEADER) + ":");
        int len = p.getNumComponentSelectors();
        ComponentSelector[] cs = new ComponentSelector[len];
        for (int i = 0; i < len; ++i) {
            cs[i] = p.getComponentSelector(i);
        }
        ComponentDBUtil.write(pw, cs, prefix + " ");
    }

    public static void write(PrintWriter pw, TargetStatus[] a, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, Context.getMessageText(TARGET_STATUS_ID_HEADER)), new Column(15, 0, Context.getMessageText(TARGET_STATUS_NAME_HEADER)), new Column(10, 0, Context.getMessageText(TARGET_STATUS_STATUS_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[3];
        for (int i = 0; i < a.length; ++i) {
            HostID hostID = a[i].getHostID();
            data[0] = hostID.toString();
            Host host = (Host)ExecutorUtil.convert(hostID, class$com$raplix$rolloutexpress$systemmodel$hostdbx$Host == null ? ExecutorUtil.class$("com.raplix.rolloutexpress.systemmodel.hostdbx.Host") : class$com$raplix$rolloutexpress$systemmodel$hostdbx$Host);
            data[1] = host.getName();
            data[2] = HostStatus2String.convert(a[i].getStatus());
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, RunningPlanBean[] b, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, Context.getMessageText(RUNNING_PLAN_TASKID_HEADER)), new Column(17, 0, Context.getMessageText(RUNNING_PLAN_STARTEDENDED_HEADER)), new Column(4, 1, Context.getMessageText(RUNNING_PLAN_LIVE_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[3];
        for (int i = 0; i < b.length; ++i) {
            data[0] = b[i].getTaskID().toString();
            Date date = b[i].getIsRunning() ? b[i].getStartDate() : b[i].getCompleteDate();
            data[1] = (String)Context.getConverterHandler().convert(date, class$java$lang$String == null ? ExecutorUtil.class$("java.lang.String") : class$java$lang$String);
            data[2] = b[i].getIsRunning() ? "+" : "-";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    private static void write(PrintWriter pw, ExecutionPlanID p, String prefix) throws Exception {
        PlanDBUtil.write(pw, (ExecutionPlan[])ExecutorUtil.convert(new ExecutionPlanID[]{p}, ExecutionPlan;.class), prefix);
    }

    private static void write(PrintWriter pw, HostID[] ha, String prefix) throws Exception {
        HostUtil.write(pw, (Host[])ExecutorUtil.convert(ha, Host;.class), prefix);
    }

    private static void write(PrintWriter pw, ComponentID[] c, GeneratedVariableSettingsID[] vs, String prefix) throws Exception {
        SummaryComponent[] comps = (Component[])ExecutorUtil.convert(c, Component;.class);
        GeneratedVariableSettings[] gvs = (GeneratedVariableSettings[])ExecutorUtil.convert(vs, GeneratedVariableSettings;.class);
        String[] varsettingsNames = new String[gvs.length];
        for (int i = 0; i < gvs.length; ++i) {
            varsettingsNames[i] = gvs[i] == null ? null : gvs[i].getName();
        }
        ComponentDBUtil.write(pw, comps, varsettingsNames, prefix);
    }

    private static void write(PrintWriter pw, UserID u, String prefix) throws Exception {
        UserUtil.detailedWrite(pw, (User[])ExecutorUtil.convert(new UserID[]{u}, User;.class), prefix);
    }

    public static void write(PrintWriter pw, ExecNativeOutput[] enoArray, String prefix) throws Exception {
        if (enoArray == null) {
            pw.println(ExecutorUtil.toText(NONE));
            return;
        }
        Column[] columns = new Column[]{new Column(45, 0, ExecutorUtil.toText(STEP_ID_HEADER)), new Column(6, 0, ExecutorUtil.toText(EXEC_NATIVE_OUTPUT_EXIT_CODE_HEADER)), new Column(50, 0, ExecutorUtil.toText(EXEC_NATIVE_OUTPUT_STDOUT_HEADER)), new Column(50, 0, ExecutorUtil.toText(EXEC_NATIVE_OUTPUT_STDERR_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[4];
        for (int i = 0; i < enoArray.length; ++i) {
            data[0] = enoArray[i].getStepID().toString();
            data[1] = enoArray[i].getExitCode() == null ? ExecutorUtil.toText(NONE) : enoArray[i].getExitCode();
            data[2] = enoArray[i].getOutput();
            data[3] = enoArray[i].getError();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    private static Object convert(Object inObj, Class cls) throws Exception {
        return Context.getConverterHandler().convert(inObj, cls);
    }

    private static String secs2String(int secs) throws Exception {
        return (String)ExecutorUtil.convert(new TimeInterval(secs, 1), String.class);
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }
}

