/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.executor.converters;

import com.raplix.rolloutexpress.executor.StepDescriptionContainer;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.String2StringArray;
import com.raplix.rolloutexpress.ui.executor.converters.PackageInfo;
import com.raplix.rolloutexpress.ui.hostdbx.converters.String2HostID;
import com.raplix.util.logger.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;

public class String2StepDescriptionContainer
implements Converter {
    private static String LABEL_DELIM = ":";
    private static String LABEL_PREFIX = "L:";
    private static String NAME_PREFIX_CHARS = "NM";
    private static String ID_PREFIX_CHARS = "ID";

    public static StepDescriptionContainer convert(String src) throws ParseException, PersistenceManagerException, RPCException {
        if (Logger.isDebugEnabled(String2StepDescriptionContainer.class.getName())) {
            Logger.debug("Got following string to convert:" + src, String2StepDescriptionContainer.class.getName());
        }
        if ((src = src.trim()).startsWith(LABEL_PREFIX)) {
            src = src.substring(LABEL_PREFIX.length());
            String2StringArray s2sa = new String2StringArray();
            s2sa.setDelimiters(LABEL_DELIM);
            ArrayList<String> argList = new ArrayList<String>(Arrays.asList(s2sa.convert(src)));
            String label = "";
            String taskId = "";
            String hostString = "";
            String next = "";
            if (!argList.isEmpty()) {
                label = (String)argList.remove(0);
            }
            if (!argList.isEmpty()) {
                next = (String)argList.remove(0);
            }
            taskId = !argList.isEmpty() && next.equals(ID_PREFIX_CHARS) ? (String)argList.remove(0) : next;
            if (!argList.isEmpty()) {
                next = (String)argList.remove(0);
                hostString = next.equals(ID_PREFIX_CHARS) && !argList.isEmpty() ? "ID:" + (String)argList.remove(0) : (next.equals(NAME_PREFIX_CHARS) ? "NM:" + (String)argList.remove(0) : next);
            }
            if (taskId.equals("") || hostString.equals("") || label.equals("")) {
                if (Logger.isDebugEnabled(String2StepDescriptionContainer.class.getName())) {
                    Logger.debug("Invalid label information.  All three of label,task and host are required.", String2StepDescriptionContainer.class.getName());
                }
                PackageInfo.throwWrongLabelArgs(src);
            }
            if (Logger.isDebugEnabled(String2StepDescriptionContainer.class.getName())) {
                Logger.debug("Got label info - label:" + label + ",taskid:" + taskId + ",hostInfo:" + hostString, String2StepDescriptionContainer.class.getName());
            }
            TaskID taskObj = new TaskID(taskId);
            HostID hostObj = String2HostID.convert(hostString);
            return new StepDescriptionContainer(taskObj, hostObj, label);
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        if (Logger.isDebugEnabled(String2StepDescriptionContainer.class.getName())) {
            Logger.debug("Got step info - stepid:" + src, String2StepDescriptionContainer.class.getName());
        }
        if (src.trim().length() == 0) {
            PackageInfo.throwWrongStepArgs(src);
        }
        StepID sid = new StepID(src);
        return new StepDescriptionContainer(sid);
    }
}

