/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.executor.commands;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepCompleteEvent;
import com.raplix.rolloutexpress.event.ROXStepEvent;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortRequestedEvent;
import com.raplix.rolloutexpress.event.ROXTaskCompleteEvent;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.ROXTaskFailedEvent;
import com.raplix.rolloutexpress.event.ROXTaskProgressEvent;
import com.raplix.rolloutexpress.event.ROXTaskStartEvent;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.event.commands.EventViewBase;
import com.raplix.rolloutexpress.ui.executor.formatters.ExecutorUtil;
import java.io.PrintWriter;
import java.util.Vector;

public class PlanView
extends EventViewBase {
    private static CommandHelp sHelp = new PlanViewHelp();
    private TaskID mID;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$executor$commands$PlanView;

    public void setID(TaskID ID2) throws Exception {
        Context.getPlanInterface().getTaskInfoForTaskID(ID2);
        this.mID = ID2;
    }

    public TaskID getID() {
        return this.mID;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        this.registerEventWriter(ROXTaskStartEvent.class, TaskStartWriter.INST);
        this.registerEventWriter(ROXTaskCompleteEvent.class, EventViewBase.HeaderWriter.INST);
        this.registerEventWriter(ROXTaskProgressEvent.class, new EventViewBase.ProgressWriter());
        this.registerEventWriter(ROXTaskFailedEvent.class, EventViewBase.MessageWriter.INST);
        this.registerEventWriter(ROXTaskAbortRequestedEvent.class, EventViewBase.MessageWriter.INST);
        this.registerEventWriter(ROXTaskAbortEvent.class, EventViewBase.MessageWriter.INST);
        this.registerEventWriter(ROXStepStartEvent.class, StepWriter.INST);
        this.registerEventWriter(ROXStepCompleteEvent.class, StepWriter.INST);
        this.registerEventWriter(ROXStepFailedEvent.class, StepWriter.INST);
        super.execute();
    }

    protected void initPrototype(ROXEvent ev) {
        ((ROXTaskEvent)ev).setTaskID(this.getID());
    }

    protected boolean isLastEvent(ROXEvent ev) {
        return ev instanceof ROXTaskCompleteEvent;
    }

    protected static class TaskStartWriter
    extends EventViewBase.HeaderWriter {
        public static final TaskStartWriter INST = new TaskStartWriter();

        protected TaskStartWriter() {
        }

        public boolean write(PrintWriter pw, ROXEvent ev) throws Exception {
            this.writeHeader(pw, ev);
            pw.println(":");
            ROXTaskStartEvent step = (ROXTaskStartEvent)ev;
            ExecutorUtil.summaryWrite(pw, step.getTaskInfo(), " ");
            return true;
        }
    }

    protected static class StepWriter
    extends EventViewBase.HeaderWriter {
        public static final StepWriter INST = new StepWriter();

        protected StepWriter() {
        }

        public boolean write(PrintWriter pw, ROXEvent ev) throws Exception {
            this.writeHeader(pw, ev);
            ROXStepEvent step = (ROXStepEvent)ev;
            Target t = step.getTarget();
            pw.print(": ");
            pw.print(step.getIsPreflight() ? "preflight" : "actual");
            pw.print(" ");
            pw.print(step.getStepTypeDescription());
            pw.print("(");
            pw.print(step.getStepID());
            pw.print(") on ");
            pw.print(t.getInitialHost().getName());
            if (!t.getInitialHostID().equals(t.getPhysicalHostID())) {
                pw.print(" (");
                pw.print(t.getPhysicalHost().getName());
                pw.print(")");
            }
            pw.println();
            return true;
        }
    }

    protected static class PlanViewHelp
    extends EventViewBase.EventViewBaseHelp {
        private static final String HEADER_PREFIX = "ui.pe.p.lo";
        private static final String COMMAND_PREFIX = "KEY:ui.pe.p.lo";
        private static final String MSG_ID_DESC = "KEY:ui.pe.p.lo.ID_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.pe.p.lo.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("ID", MSG_ID_DESC));
            super.addArguments(map);
            return map;
        }

        PlanViewHelp() {
            super(class$com$raplix$rolloutexpress$ui$executor$commands$PlanView == null ? (class$com$raplix$rolloutexpress$ui$executor$commands$PlanView = PlanView.class$("com.raplix.rolloutexpress.ui.executor.commands.PlanView")) : class$com$raplix$rolloutexpress$ui$executor$commands$PlanView, MSG_COMMAND_DESC);
        }
    }
}

