/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.executor.commands;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.executor.TaskDescriptor;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.VariableSettingsSelector;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.converters.TimeInterval;
import com.raplix.rolloutexpress.ui.executor.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.Names;
import com.raplix.util.iowrappers.ReaderWrapper;
import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;

public class PlanRun
extends SessionBase
implements OutputCommand,
Names {
    private static CommandHelp sHelp = new PlanRunHelp();
    private ExecutionPlanID mExecutionPlanID;
    private HostID[][] mAllTargets;
    private String[][] mAllComponents;
    private String[][] mAllVarSettings;
    private boolean mIsPreflightOnly;
    private Boolean mPerformDetailedPreflight;
    private Integer mHostsRunningLimit;
    private TimeInterval mPlanTimeout;
    private TimeInterval mNativeCallTimeout;
    private TaskID mResult;
    private ReaderWrapper mPlanVariables = null;
    private OutputStream mOutputStream = null;
    private Closer mCloser = new Closer();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$executor$commands$PlanRun;

    public void setOutputStream(OutputStream inStream) {
        this.mOutputStream = inStream;
    }

    public OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mExecutionPlanID;
    }

    public void setExecutionPlanID(ExecutionPlanID executionPlanID) {
        this.mExecutionPlanID = executionPlanID;
    }

    public HostID[][] getAllTargets() {
        return this.mAllTargets;
    }

    public void setAllTargets(HostID[][] targets) {
        this.mAllTargets = targets;
    }

    public String[][] getAllComponents() {
        return this.mAllComponents;
    }

    public void setAllComponents(String[][] components) {
        this.mAllComponents = components;
    }

    public String[][] getAllVarSettings() {
        return this.mAllVarSettings;
    }

    public void setAllVarSettings(String[][] varsettings) {
        this.mAllVarSettings = varsettings;
    }

    public boolean getIsPreflightOnly() {
        return this.mIsPreflightOnly;
    }

    public void setIsPreflightOnly(boolean isPreflightOnly) {
        this.mIsPreflightOnly = isPreflightOnly;
    }

    public Boolean getPerformDetailedPreflight() {
        return this.mPerformDetailedPreflight;
    }

    public void setPerformDetailedPreflight(Boolean performDetailedPreflight) {
        this.mPerformDetailedPreflight = performDetailedPreflight;
    }

    public Integer getHostsRunningLimit() {
        return this.mHostsRunningLimit;
    }

    public void setHostsRunningLimit(Integer numHosts) {
        this.mHostsRunningLimit = numHosts;
    }

    public TimeInterval getPlanTimeout() {
        return this.mPlanTimeout;
    }

    public void setPlanTimeout(TimeInterval planTimeout) {
        this.mPlanTimeout = planTimeout;
    }

    public TimeInterval getNativeCallTimeout() {
        return this.mNativeCallTimeout;
    }

    public void setNativeCallTimeout(TimeInterval nativeCallTimeout) {
        this.mNativeCallTimeout = nativeCallTimeout;
    }

    public ReaderWrapper getPlanVariables() {
        return this.mPlanVariables;
    }

    public void setPlanVariables(ReaderWrapper inPlanVariables) {
        this.mPlanVariables = inPlanVariables;
        this.mCloser.register(this.mPlanVariables);
    }

    protected void setResult(TaskID result) {
        this.mResult = result;
    }

    public TaskID getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        PlanInterface pe = Context.getPlanInterface();
        ExecutionPlanID planID = this.getExecutionPlanID();
        TaskDescriptor theDescriptor = pe.generateTaskDescriptorForPlan(planID);
        RunLevel runLevel = this.getIsPreflightOnly() ? RunLevel.PREFLIGHT : RunLevel.ACTUAL;
        theDescriptor.setRunLevel(runLevel);
        theDescriptor.setRoxUser(Context.getSessionManager().getCurrentUserID());
        HostID[][] targets = this.getAllTargets();
        String[][] components = this.getAllComponents();
        String[][] varsettings = this.getAllVarSettings();
        Object[] prompts = theDescriptor.getSubplanPrompts();
        int len = prompts.length;
        if (targets == null || targets.length != len) {
            PackageInfo.throwInvalidPromptTargets((Object[])targets, prompts);
        }
        if (components == null) {
            components = new String[len][0];
        } else if (components.length != len) {
            PackageInfo.throwIllegalNumberOfComponents(-1, len);
        }
        if (varsettings == null) {
            varsettings = new String[len][0];
        } else if (varsettings.length != len) {
            PackageInfo.throwIllegalNumberOfVarSettings(-1, len);
        }
        for (int i = 0; i < len; ++i) {
            ((SubplanPrompt)prompts[i]).setInitialTargets(targets[i]);
        }
        this.setComponentChoices(components, (SubplanPrompt[])prompts);
        this.setVarSettingChoices(varsettings, (SubplanPrompt[])prompts);
        boolean detailedPreflight = this.getPerformDetailedPreflight() == null ? pe.getDefaultDetailedPreflight() : this.getPerformDetailedPreflight().booleanValue();
        theDescriptor.setDetailedPreflight(detailedPreflight);
        int hostsRunningLimit = this.getHostsRunningLimit() == null ? pe.getConfigDefaultPlanThrottle() : this.getHostsRunningLimit().intValue();
        theDescriptor.setPlanThrottle(hostsRunningLimit);
        TimeInterval pto = this.getPlanTimeout();
        if (pto.isIndefinite()) {
            PackageInfo.throwIndefinitePlanTimeout();
        }
        theDescriptor.setPlanTimeoutSecs((int)pto.convertRound(1));
        TimeInterval ncto = this.getNativeCallTimeout();
        if (ncto.isIndefinite()) {
            PackageInfo.throwIndefiniteNativeCallTimeout();
        }
        theDescriptor.setNativeCallTimeoutSecs((int)ncto.convertRound(1));
        PromptParamList ppl = theDescriptor.getPlanParameters();
        String[] varNames = ppl.getVarNames();
        if (varNames.length > 0) {
            boolean isFile;
            if (this.getOutputStream() == null) {
                this.setOutputStream(System.out);
            }
            if (this.getPlanVariables() == null) {
                this.setPlanVariables(new ReaderWrapper("-"));
            }
            VariableSettingsHolder vsh = new VariableSettingsHolder();
            PrintWriter pw = null;
            PromptParam pp = null;
            Reader r = this.getPlanVariables().getReader();
            boolean bl = isFile = !this.getPlanVariables().getStandard();
            if (!isFile) {
                pw = new PrintWriter(this.getOutputStream());
                pw.println("Enter plan variables.");
            }
            BufferedReader planVariables = new BufferedReader(r);
            String varValue = null;
            for (int i = 0; i < varNames.length; ++i) {
                pp = ppl.getParam(varNames[i]);
                if (!isFile) {
                    if (pp.getPrompt() != null) {
                        pw.println(pp.getPrompt());
                    } else {
                        pw.println(varNames[i] + ": ");
                    }
                    pw.print(">");
                    pw.flush();
                }
                if ((varValue = planVariables.readLine()) == null) {
                    PackageInfo.throwIllegalPlanVariable(varNames[i], varValue);
                    continue;
                }
                vsh.setVarValue(varNames[i], varValue);
            }
            if (!isFile) {
                pw.println("");
                pw.flush();
            }
            theDescriptor.setPlanParameterValues(vsh);
        }
        this.setResult(pe.runPlan(theDescriptor));
    }

    private void setComponentChoices(String[][] comps, SubplanPrompt[] prompts) throws Exception {
        int numPlans = prompts.length;
        for (int i = 0; i < numPlans; ++i) {
            int numComponents = prompts[i].getNumComponentSelectors();
            if (comps[i].length != numComponents) {
                PackageInfo.throwIllegalNumberOfComponents(i, numComponents);
            }
            for (int j = 0; j < numComponents; ++j) {
                ComponentSelector cs = prompts[i].getComponentSelector(j);
                int newIndex = this.getIndexFromComponent(comps[i][j], cs);
                if (newIndex == -1) {
                    PackageInfo.throwCannotResolveComponent(comps[i][j], cs.getComponentRef().getComponentName());
                }
                cs.setIndexOfCurrent(newIndex);
            }
        }
    }

    private void setVarSettingChoices(String[][] varsettings, SubplanPrompt[] prompts) throws Exception {
        int numPlans = prompts.length;
        for (int i = 0; i < numPlans; ++i) {
            int numVarSettings = prompts[i].getNumComponentSelectors();
            if (varsettings[i].length != numVarSettings) {
                PackageInfo.throwIllegalNumberOfVarSettings(i, numVarSettings);
            }
            for (int j = 0; j < numVarSettings; ++j) {
                ComponentSelector cs = prompts[i].getComponentSelector(j);
                VariableSettingsSelector varSelector = cs.getCurrent();
                int newIndex = this.getIndexFromVarSettings(varsettings[i][j], varSelector, cs);
                varSelector.setIndexOfCurrent(newIndex);
            }
        }
    }

    private int getIndexFromComponent(String comp, ComponentSelector compSelector) {
        int index = comp.equals("#") ? compSelector.getIndexOfRecommended() : (comp.equals("-") ? compSelector.getIndexOfLatest() : (comp.equals("+") ? compSelector.getIndexOfDefault() : compSelector.getIndexOfVersion(comp)));
        if (index == -1) {
            index = -1;
        }
        return index;
    }

    private int getIndexFromVarSettings(String varsettings, VariableSettingsSelector varSelector, ComponentSelector cs) {
        if (varsettings.equals("+")) {
            return -1;
        }
        int index = varSelector.getIndexOfName(varsettings);
        if (index == -1) {
            PackageInfo.throwCannotResolveVarSettings(varsettings, cs.getComponentRef().getComponentName(), cs.getCurrent().getComponent().getVersionNumber().getAsString());
        }
        return index;
    }

    public void cleanup() {
        this.mCloser.closeAll();
    }

    protected static class PlanRunHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.pe.p.run";
        private static final String MSG_EXECUTION_PLAN_ID_DESC = "KEY:ui.pe.p.run.EXECUTION_PLAN_ID_DESC";
        private static final String MSG_TARGETS_DESC = "KEY:ui.pe.p.run.TARGETS_DESC";
        private static final String MSG_COMPONENTS_DESC = "KEY:ui.pe.p.run.COMPONENTS_DESC";
        private static final String MSG_VARSETTINGS_DESC = "KEY:ui.pe.p.run.VARSETTINGS_DESC";
        private static final String MSG_IS_PREFLIGHT_ONLY_DESC = "KEY:ui.pe.p.run.IS_PREFLIGHT_ONLY_DESC";
        private static final String MSG_PERFORM_DETAILED_PREFLIGHT_DESC = "KEY:ui.pe.p.run.PERFORM_DETAILED_PREFLIGHT_DESC";
        private static final String MSG_HOSTS_RUNNING_LIMIT_DESC = "KEY:ui.pe.p.run.HOSTS_RUNNING_LIMIT_DESC";
        private static final String MSG_PLAN_TIMEOUT_DESC = "KEY:ui.pe.p.run.PLAN_TIMEOUT_DESC";
        private static final String MSG_NATIVE_CALL_TIMEOUT_DESC = "KEY:ui.pe.p.run.NATIVE_CALL_TIMEOUT_DESC";
        private static final String MSG_PLAN_VARIABLES_DESC = "KEY:ui.pe.p.run.PLAN_VARIABLES_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.pe.p.run.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.pe.p.run.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("executionPlanID", MSG_EXECUTION_PLAN_ID_DESC, "PID"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("allTargets", MSG_TARGETS_DESC, "tar"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("allComponents", MSG_COMPONENTS_DESC, "comp"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("allVarSettings", MSG_VARSETTINGS_DESC, "vs"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("isPreflightOnly", MSG_IS_PREFLIGHT_ONLY_DESC, "po"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("performDetailedPreflight", MSG_PERFORM_DETAILED_PREFLIGHT_DESC, "pdp"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("hostsRunningLimit", MSG_HOSTS_RUNNING_LIMIT_DESC, "hrl"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("planTimeout", MSG_PLAN_TIMEOUT_DESC, "pto"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("nativeCallTimeout", MSG_NATIVE_CALL_TIMEOUT_DESC, "nto"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("planVariables", MSG_PLAN_VARIABLES_DESC, "f"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        PlanRunHelp() {
            super(class$com$raplix$rolloutexpress$ui$executor$commands$PlanRun == null ? (class$com$raplix$rolloutexpress$ui$executor$commands$PlanRun = PlanRun.class$("com.raplix.rolloutexpress.ui.executor.commands.PlanRun")) : class$com$raplix$rolloutexpress$ui$executor$commands$PlanRun, MSG_COMMAND_DESC);
        }
    }
}

