/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.executor.commands;

import com.raplix.rolloutexpress.ui.Context;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "ui.pe";
    public static final String MSG_EX_INDEFINITE_PLAN_TIMEOUT = "ui.pe.EX_INDEFINITE_PLAN_TIMEOUT";
    public static final String MSG_EX_INDEFINITE_NATIVE_CALL_TIMEOUT = "ui.pe.EX_INDEFINITE_NATIVE_CALL_TIMEOUT";
    public static final String MSG_EX_INVALID_PROMPT_TARGETS = "ui.pe.EX_INVALID_PROMPT_TARGETS";
    public static final String MSG_EX_WRONG_NUMBER_OF_COMPONENTS = "ui.pe.EX_WRONG_NUMBER_OF_COMPONENTS";
    public static final String MSG_EX_WRONG_NUMBER_OF_COMPONENT_ARRAYS = "ui.pe.EX_WRONG_NUMBER_OF_COMPONENT_ARRAYS";
    public static final String MSG_EX_CANNOT_RESOLVE_COMPONENTS = "ui.pe.EX_CANNOT_RESOLVE_COMPONENTS";
    public static final String MSG_EX_WRONG_NUMBER_OF_VARSETTINGS = "ui.pe.EX_WRONG_NUMBER_OF_VARSETTINGS";
    public static final String MSG_EX_WRONG_NUMBER_OF_VARSETTINGS_ARRAYS = "ui.pe.EX_WRONG_NUMBER_OF_VARSETTINGS_ARRAYS";
    public static final String MSG_EX_CANNOT_RESOLVE_VARSETTINGS = "ui.pe.EX_CANNOT_RESOLVE_VARSETTINGS";
    public static final String MSG_EX_ILLEGAL_PLAN_VARIABLE = "ui.pe.EX_ILLEGAL_PLAN_VARIABLE";
    public static final String MSG_EX_MISSING_INPUT_PARAMETERS = "ui.pe.EX_MISSING_INPUT_PARAMETERS";

    private PackageInfo() {
    }

    public static void throwIndefinitePlanTimeout() {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_INDEFINITE_PLAN_TIMEOUT));
    }

    public static void throwIndefiniteNativeCallTimeout() {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_INDEFINITE_NATIVE_CALL_TIMEOUT));
    }

    public static void throwInvalidPromptTargets(Object[] actual, Object[] expected) {
        int len1 = actual == null ? 0 : actual.length;
        throw new IllegalArgumentException(Context.getMessageText(MSG_EX_INVALID_PROMPT_TARGETS, new Integer(len1), new Integer(expected.length)));
    }

    public static void throwIllegalNumberOfVarSettings(int arrayIndex, int expectedNumElements) {
        if (arrayIndex != -1) {
            throw new IllegalArgumentException(Context.getMessageText(MSG_EX_WRONG_NUMBER_OF_VARSETTINGS, Integer.toString(arrayIndex), Integer.toString(expectedNumElements)));
        }
        throw new IllegalArgumentException(Context.getMessageText(MSG_EX_WRONG_NUMBER_OF_VARSETTINGS_ARRAYS, Integer.toString(expectedNumElements)));
    }

    public static void throwIllegalNumberOfComponents(int arrayIndex, int expectedNumElements) {
        if (arrayIndex != -1) {
            throw new IllegalArgumentException(Context.getMessageText(MSG_EX_WRONG_NUMBER_OF_COMPONENTS, Integer.toString(arrayIndex), Integer.toString(expectedNumElements)));
        }
        throw new IllegalArgumentException(Context.getMessageText(MSG_EX_WRONG_NUMBER_OF_COMPONENT_ARRAYS, Integer.toString(expectedNumElements)));
    }

    public static void throwCannotResolveComponent(String choice, String compName) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_CANNOT_RESOLVE_COMPONENTS, choice, compName));
    }

    public static void throwCannotResolveVarSettings(String choice, String compName, String compBuild) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_CANNOT_RESOLVE_VARSETTINGS, choice, compName + ":" + compBuild));
    }

    public static void throwIllegalPlanVariable(String varName, String varValue) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_ILLEGAL_PLAN_VARIABLE, varName, varValue));
    }

    public static void throwMissingInputParameters() {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_MISSING_INPUT_PARAMETERS));
    }

    public static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }

    public static String toText(String messageKey, String arg1) {
        return Context.getMessageText(messageKey, arg1);
    }

    public static String toText(String messageKey, String arg1, String arg2) {
        return Context.getMessageText(messageKey, arg1, arg2);
    }
}

