/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.event.commands;

import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventID;
import com.raplix.rolloutexpress.event.query.bean.ProgressInterface;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.reflect.ClassUtil;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public abstract class EventViewBase
extends SessionBase
implements OutputCommand {
    private static final long POLL_DELAY = 5000L;
    private static final long QUERY_LAG = 10000L;
    private static final String HEADER_PREFIX = "ui.event.e.lq";
    private boolean mShowOld;
    private boolean mFollow = true;
    private OutputStream mOutputStream;
    private Hashtable mWriters = new Hashtable();
    protected static final EventWriter DEFAULT_WRITER = MessageWriter.INST;
    static /* synthetic */ Class class$java$lang$String;

    public void setOutputStream(OutputStream stream) {
        this.mOutputStream = stream;
    }

    public void setShowOld(boolean showOld) {
        this.mShowOld = showOld;
    }

    public boolean getShowOld() {
        return this.mShowOld;
    }

    public void setFollow(boolean follow) {
        this.mFollow = follow;
    }

    public boolean getFollow() {
        return this.mFollow;
    }

    protected void registerEventWriter(Class eventClass, EventWriter writer) {
        this.mWriters.put(eventClass, writer);
    }

    protected Enumeration getEventClasses() {
        return this.mWriters.keys();
    }

    protected EventWriter getEventWriter(Class eventClass) {
        EventWriter result = (EventWriter)this.mWriters.get(eventClass);
        if (result == null) {
            result = DEFAULT_WRITER;
        }
        return result;
    }

    protected abstract void initPrototype(ROXEvent var1);

    protected abstract boolean isLastEvent(ROXEvent var1);

    public void execute() throws Exception {
        if (this.mOutputStream == null) {
            this.setOutputStream(System.out);
        }
        long nextStart = this.getShowOld() ? 0L : System.currentTimeMillis();
        NotificationRPCInterface notification = Context.getNotificationRPCInterface();
        Vector<ROXEvent> prototypes = new Vector<ROXEvent>();
        Enumeration eventClasses = this.getEventClasses();
        while (eventClasses.hasMoreElements()) {
            Class eventClass = (Class)eventClasses.nextElement();
            ROXEvent event = (ROXEvent)ClassUtil.createObject(eventClass);
            this.initPrototype(event);
            prototypes.addElement(event);
        }
        PrintWriter pw = new PrintWriter(this.mOutputStream);
        HashSet<ROXEventID> seen = new HashSet<ROXEventID>();
        boolean seenLastEvent = false;
        while (true) {
            Vector matches;
            try {
                matches = notification.query(prototypes, true);
            }
            catch (EmptyQueryException e) {
                matches = new Vector();
            }
            Enumeration e = matches.elements();
            while (e.hasMoreElements()) {
                ROXEvent ev = (ROXEvent)e.nextElement();
                if (seen.contains(ev.getEventID())) continue;
                EventWriter writer = this.getEventWriter(ev.getClass());
                if (writer.write(pw, ev)) {
                    seen.add(ev.getEventID());
                }
                seenLastEvent = this.isLastEvent(ev);
                long timeStamp = ev.getDate().getTime() - 10000L;
                if (timeStamp <= nextStart) continue;
                nextStart = timeStamp;
            }
            pw.flush();
            if (!this.getFollow() || seenLastEvent) break;
            Thread.sleep(5000L);
        }
    }

    protected static class ProgressWriter
    extends HeaderWriter {
        private double mLastProgress = -1.0;

        public boolean write(PrintWriter pw, ROXEvent ev) throws Exception {
            double progress = ((ProgressInterface)((Object)ev)).getProgress();
            if (progress > this.mLastProgress) {
                this.mLastProgress = progress;
                this.writeHeader(pw, ev);
                pw.print(": ");
                pw.print(progress);
                pw.println('%');
            }
            return false;
        }
    }

    protected static class MessageWriter
    extends HeaderWriter {
        public static final MessageWriter INST = new MessageWriter();

        protected MessageWriter() {
        }

        public boolean write(PrintWriter pw, ROXEvent ev) throws Exception {
            this.writeHeader(pw, ev);
            pw.println(": ");
            pw.print(' ');
            pw.println(ev.getMessage());
            return true;
        }
    }

    protected static class HeaderWriter
    implements EventWriter {
        public static final HeaderWriter INST = new HeaderWriter();

        protected HeaderWriter() {
        }

        public void writeHeader(PrintWriter pw, ROXEvent ev) throws Exception {
            pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? (class$java$lang$String = EventViewBase.class$("java.lang.String")) : class$java$lang$String));
            pw.print(' ');
            pw.print(ev.describe());
        }

        public boolean write(PrintWriter pw, ROXEvent ev) throws Exception {
            this.writeHeader(pw, ev);
            pw.println();
            return true;
        }
    }

    protected static interface EventWriter {
        public boolean write(PrintWriter var1, ROXEvent var2) throws Exception;
    }

    protected static class EventViewBaseHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.event.e.lq";
        private static final String MSG_OLD_DESC = "KEY:ui.event.e.lq.OLD_DESC";
        private static final String MSG_NEW_DESC = "KEY:ui.event.e.lq.NEW_DESC";

        protected void addArguments(Vector map) {
            map.addElement(new CommandHelpBase.OptionalArgInfo("showOld", MSG_OLD_DESC, "old"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("follow", MSG_NEW_DESC, "new"));
        }

        protected EventViewBaseHelp(Class cls, String desc) {
            super(cls, desc);
        }
    }
}

