/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.difference.formatters;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.event.query.bean.RunningDiffBean;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.converters.TimeInterval;
import com.raplix.rolloutexpress.ui.difference.converters.Level;
import com.raplix.rolloutexpress.ui.difference.converters.Scope;
import com.raplix.rolloutexpress.ui.difference.converters.Style;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.string.StringUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;
import java.util.Date;

public final class DifferenceUtil {
    private static final String MSG_ID_HEADER = "ui.cmp.format.ID_HEADER";
    private static final String MSG_NAME_HEADER = "ui.cmp.format.NAME_HEADER";
    private static final String MSG_CATEGORY_HEADER = "ui.cmp.format.CATEGORY_HEADER";
    private static final String MSG_DESCRIPTION_HEADER = "ui.cmp.format.DESCRIPTION_HEADER";
    private static final String MSG_STYLE_HEADER = "ui.cmp.format.STYLE_HEADER";
    private static final String MSG_LEVEL_HEADER = "ui.cmp.format.LEVEL_HEADER";
    private static final String MSG_SCOPE_HEADER = "ui.cmp.format.SCOPE_HEADER";
    private static final String MSG_SRCHOSTID_HEADER = "ui.cmp.format.SRCHOSTID_HEADER";
    private static final String MSG_DSTHOSTID_HEADER = "ui.cmp.format.DSTHOSTID_HEADER";
    private static final String MSG_DSTHOSTSETID_HEADER = "ui.cmp.format.DSTHOSTSETID_HEADER";
    private static final String MSG_SRCDIR_HEADER = "ui.cmp.format.SRCDIR_HEADER";
    private static final String MSG_DSTDIR_HEADER = "ui.cmp.format.DSTDIR_HEADER";
    private static final String MSG_IGNORESETTINGS_HEADER = "ui.cmp.format.IGNORESETTINGS_HEADER";
    private static final String MSG_PATH_HEADER = "ui.cmp.format.PATH_HEADER";
    private static final String MSG_SWITCH_HEADER = "ui.cmp.format.SWITCH_HEADER";
    private static final String MSG_COMPONENTREF_HEADER = "ui.cmp.format.COMPONENTREF_HEADER";
    private static final String MSG_TIMEOUTSECS_HEADER = "ui.cmp.format.TIMEOUTSECS_HEADER";
    private static final String MSG_INCLUDESUBDIRECTORIES_HEADER = "ui.cmp.format.INCLUDESUBDIRECTORIES_HEADER";
    private static final String MSG_FOLLOWSYMBOLICLINKS_HEADER = "ui.cmp.format.FOLLOWSYMBOLICLINKS_HEADER";
    private static final String MSG_USESCRIPTS_HEADER = "ui.cmp.format.USESCRIPTS_HEADER";
    private static final String MSG_USESAMEPREPARE_HEADER = "ui.cmp.format.USESAMEPREPARE_HEADER";
    private static final String MSG_SRCPREPARE_HEADER = "ui.cmp.format.SRCPREPARE_HEADER";
    private static final String MSG_DSTPREPARE_HEADER = "ui.cmp.format.DSTPREPARE_HEADER";
    private static final String MSG_USESAMECLEANUP_HEADER = "ui.cmp.format.USESAMECLEANUP_HEADER";
    private static final String MSG_SRCCLEANUP_HEADER = "ui.cmp.format.SRCCLEANUP_HEADER";
    private static final String MSG_DSTCLEANUP_HEADER = "ui.cmp.format.DSTCLEANUP_HEADER";
    private static final String MSG_STARTEDENDED_HEADER = "ui.cmp.format.STARTEDENDED_HEADER";
    private static final String MSG_LIVE_HEADER = "ui.cmp.format.LIVE_HEADER";

    private DifferenceUtil() {
    }

    public static String format(InstalledComponentID icID) throws Exception {
        InstalledComponent ic = icID.getByIDQuery().select();
        SummaryComponent sc = ic.getComponentID().getByIDQuery().selectSummaryView();
        return (String)Context.getConverterHandler().convert(new InstalledComponentRef(sc.getFullName(), sc.getVersionNumber().getAsString(), ic.getInstallPath()), String.class);
    }

    public static void write(PrintWriter pw, DifferenceSettings s, String prefix) throws Exception {
        pw.print(prefix);
        pw.print(Context.getMessageText(MSG_ID_HEADER));
        pw.print(": ");
        pw.println(s.getObjectID());
        pw.print(prefix);
        pw.print(Context.getMessageText(MSG_NAME_HEADER));
        pw.print(": ");
        pw.println(s.getName());
        pw.print(prefix);
        pw.print(Context.getMessageText(MSG_CATEGORY_HEADER));
        pw.print(": ");
        pw.println(CategoriesBean.getCategoryNamesString(s.getCategories()));
        pw.print(prefix);
        pw.print(Context.getMessageText(MSG_DESCRIPTION_HEADER));
        pw.print(": ");
        pw.println(s.getDescription());
        if (s.getDiffStyle() != -1) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_STYLE_HEADER));
            pw.print(": ");
            pw.println(Context.getConverterHandler().convert(new Style(s.getDiffStyle()), String.class));
        }
        if (s.getDiffLevel() != -1) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_LEVEL_HEADER));
            pw.print(": ");
            pw.println(Context.getConverterHandler().convert(new Level(s.getDiffLevel()), String.class));
        }
        if (s.getDiffScope() != -1) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_SCOPE_HEADER));
            pw.print(": ");
            pw.println(Context.getConverterHandler().convert(new Scope(s.getDiffScope()), String.class));
        }
        if (!StringUtil.isEmpty(s.getSrcHostID())) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_SRCHOSTID_HEADER));
            pw.print(": ");
            pw.println(s.getSrcHostID());
        }
        if (!StringUtil.isEmpty(s.getDstHostID())) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_DSTHOSTID_HEADER));
            pw.print(": ");
            pw.println(s.getDstHostID());
        }
        if (!StringUtil.isEmpty(s.getDstHostSetID())) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_DSTHOSTSETID_HEADER));
            pw.print(": ");
            pw.println(s.getDstHostSetID());
        }
        if (s.getDiffStyle() == 2) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_SRCDIR_HEADER));
            pw.print(": ");
            pw.println(s.getSrcDir());
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_DSTDIR_HEADER));
            pw.print(": ");
            pw.println(s.getDstDir());
        }
        if (s.getDiffStyle() != 0) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_IGNORESETTINGS_HEADER));
            pw.println(':');
            String[] paths = s.getIgnorePaths();
            Column[] columns = new Column[]{new Column(60, 0, Context.getMessageText(MSG_PATH_HEADER))};
            Table t = new Table(pw, columns, prefix + " ");
            String[] data = new String[1];
            for (int i = 0; i < paths.length; ++i) {
                data[0] = paths[i];
                t.printRow(CollectionUtil.getEnumeration(data));
            }
            t.endPrinting();
        }
        if (s.getDiffStyle() == 1 && s.getDiffScope() == 0) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_COMPONENTREF_HEADER));
            pw.print(": ");
            pw.println(DifferenceUtil.format(s.getInstalledComponentID()));
        }
        pw.print(prefix);
        pw.print(Context.getMessageText(MSG_TIMEOUTSECS_HEADER));
        pw.print(": ");
        pw.println(Context.getConverterHandler().convert(new TimeInterval(s.getTimeoutSecs(), 1), String.class));
        if (s.getDiffStyle() == 2) {
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_INCLUDESUBDIRECTORIES_HEADER));
            pw.print(": ");
            pw.println(s.getIncludeSubdirectories() ? "+" : "-");
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_FOLLOWSYMBOLICLINKS_HEADER));
            pw.print(": ");
            pw.println(s.getFollowSymlinks() ? "+" : "-");
            pw.print(prefix);
            pw.print(Context.getMessageText(MSG_USESCRIPTS_HEADER));
            pw.print(": ");
            pw.println(s.getUseMiniPlans() ? "+" : "-");
            if (s.getUseMiniPlans()) {
                pw.print(prefix);
                pw.print(Context.getMessageText(MSG_USESAMEPREPARE_HEADER));
                pw.print(": ");
                pw.println(s.getDstUseSrcP() ? "+" : "-");
                pw.print(prefix);
                pw.print(Context.getMessageText(MSG_SRCPREPARE_HEADER));
                pw.print(": ");
                pw.println(s.getSrcPrepare());
                if (!s.getDstUseSrcP()) {
                    pw.print(prefix);
                    pw.print(Context.getMessageText(MSG_DSTPREPARE_HEADER));
                    pw.print(": ");
                    pw.println(s.getDstPrepare());
                }
                pw.print(prefix);
                pw.print(Context.getMessageText(MSG_USESAMECLEANUP_HEADER));
                pw.print(": ");
                pw.println(s.getDstUseSrcC() ? "+" : "-");
                pw.print(prefix);
                pw.print(Context.getMessageText(MSG_SRCCLEANUP_HEADER));
                pw.print(": ");
                pw.println(s.getSrcCleanup());
                if (!s.getDstUseSrcC()) {
                    pw.print(prefix);
                    pw.print(Context.getMessageText(MSG_DSTCLEANUP_HEADER));
                    pw.print(": ");
                    pw.println(s.getDstCleanup());
                }
            }
        }
    }

    public static void write(PrintWriter pw, DifferenceSettings[] s, String prefix) {
        Column[] columns = new Column[]{new Column(45, 0, Context.getMessageText(MSG_ID_HEADER)), new Column(15, 0, Context.getMessageText(MSG_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < s.length; ++i) {
            data[0] = s[i].getObjectID().toString();
            data[1] = s[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, RunningDiffBean[] b, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, Context.getMessageText(MSG_ID_HEADER)), new Column(17, 0, Context.getMessageText(MSG_STARTEDENDED_HEADER)), new Column(4, 1, Context.getMessageText(MSG_LIVE_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[3];
        for (int i = 0; i < b.length; ++i) {
            data[0] = b[i].getDifferenceJobID().toString();
            Date date = b[i].getIsRunning() ? b[i].getStartDate() : b[i].getCompleteDate();
            data[1] = (String)Context.getConverterHandler().convert(date, class$java$lang$String == null ? DifferenceUtil.class$("java.lang.String") : class$java$lang$String);
            data[2] = b[i].getIsRunning() ? "+" : "-";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }
}

