/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.difference.commands;

import com.raplix.rolloutexpress.ui.Context;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "ui.cmp";
    public static final String EX_INVALID_ARGUMENT = "ui.cmp.EX_INVALID_ARGUMENT";
    public static final String EX_MISSING_ARGUMENT = "ui.cmp.EX_MISSING_ARGUMENT";
    public static final String EX_COMPONENT_NONE = "ui.cmp.EX_COMPONENT_NONE";
    public static final String EX_COMPONENT_MANY = "ui.cmp.EX_COMPONENT_MANY";
    public static final String EX_RETRIEVE_JOBID = "ui.cmp.EX_RETRIEVE_JOBID";
    public static final String EX_DELETE_FAILED = "ui.cmp.EX_DELETE_FAILED";

    private PackageInfo() {
    }

    public static IllegalArgumentException createInvalidArgument() {
        return new IllegalArgumentException(Context.getMessageText(EX_INVALID_ARGUMENT));
    }

    public static IllegalArgumentException createMissingArgument(String inMissingArgument) {
        return new IllegalArgumentException(Context.getMessageText(EX_MISSING_ARGUMENT, inMissingArgument));
    }

    public static IllegalArgumentException createComponentNone() {
        return new IllegalArgumentException(Context.getMessageText(EX_COMPONENT_NONE));
    }

    public static IllegalArgumentException createComponentMany() {
        return new IllegalArgumentException(Context.getMessageText(EX_COMPONENT_MANY));
    }

    public static void throwInvalidJobID(String jobID) {
        throw new IllegalArgumentException(Context.getMessageText(EX_RETRIEVE_JOBID, jobID));
    }

    public static void throwDeleteFailed(String task) {
        throw new IllegalArgumentException(Context.getMessageText(EX_DELETE_FAILED, task));
    }
}

