/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.difference.commands;

import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.ui.converters.TimeInterval;
import com.raplix.rolloutexpress.ui.difference.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.difference.converters.Level;
import com.raplix.rolloutexpress.ui.difference.converters.Scope;
import com.raplix.rolloutexpress.ui.difference.converters.Style;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.ReaderWrapper;

public abstract class DifferenceSettingsEditBase
extends SessionBase {
    private Closer mCloser = new Closer();
    private String mName;
    private String mDescription;
    private Style mStyle;
    private Level mLevel;
    private Scope mScope;
    private HostID mSrcHostID;
    private HostID mDstHostID;
    private HostSetID mDstHostSetID;
    private String mSrcDir;
    private String mDstDir;
    private String[] mIgnorePaths;
    private InstalledComponentRef mInstalledComponentRef;
    private TimeInterval mTimeoutSecs;
    private Boolean mIncludeSubdirectories;
    private Boolean mFollowSymbolicLinks;
    private Boolean mUseMiniPlans = null;
    private Boolean mUseSamePrepareSteps = null;
    private ReaderWrapper mSrcPrepareSteps = null;
    private ReaderWrapper mDstPrepareSteps = null;
    private Boolean mUseSameCleanupSteps = null;
    private ReaderWrapper mSrcCleanupSteps = null;
    private ReaderWrapper mDstCleanupSteps = null;
    protected static final int MODE_ADD = 0;
    protected static final int MODE_MODIFY = 1;

    private String readerWrapper2String(ReaderWrapper inReaderWrapper, String inMissingArgument) throws Exception {
        if (inReaderWrapper == null) {
            throw PackageInfo.createMissingArgument(inMissingArgument);
        }
        return new String(CopyUtil.readText(inReaderWrapper.getReader()));
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setStyle(Style style) {
        this.mStyle = style;
    }

    public Style getStyle() {
        return this.mStyle;
    }

    public void setLevel(Level level) {
        this.mLevel = level;
    }

    public Level getLevel() {
        return this.mLevel;
    }

    public void setScope(Scope scope) {
        this.mScope = scope;
    }

    public Scope getScope() {
        return this.mScope;
    }

    public void setSrcHostID(HostID srcHostID) {
        this.mSrcHostID = srcHostID;
    }

    public HostID getSrcHostID() {
        return this.mSrcHostID;
    }

    public void setDstHostID(HostID dstHostID) {
        this.mDstHostID = dstHostID;
    }

    public HostID getDstHostID() {
        return this.mDstHostID;
    }

    public void setDstHostSetID(HostSetID dstHostSetID) {
        this.mDstHostSetID = dstHostSetID;
    }

    public HostSetID getDstHostSetID() {
        return this.mDstHostSetID;
    }

    public void setSrcDir(String srcDir) {
        this.mSrcDir = srcDir;
    }

    public String getSrcDir() {
        return this.mSrcDir;
    }

    public void setDstDir(String dstDir) {
        this.mDstDir = dstDir;
    }

    public String getDstDir() {
        return this.mDstDir;
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this.mIgnorePaths = ignorePaths;
    }

    public String[] getIgnorePaths() {
        return this.mIgnorePaths;
    }

    public void setInstalledComponentRef(InstalledComponentRef installedComponentRef) {
        this.mInstalledComponentRef = installedComponentRef;
    }

    public InstalledComponentRef getInstalledComponentRef() {
        return this.mInstalledComponentRef;
    }

    public void setTimeoutSecs(TimeInterval timeoutSecs) {
        this.mTimeoutSecs = timeoutSecs;
    }

    public TimeInterval getTimeoutSecs() {
        return this.mTimeoutSecs;
    }

    public void setIncludeSubdirectories(Boolean includeSubdirectories) {
        this.mIncludeSubdirectories = includeSubdirectories;
    }

    public Boolean getIncludeSubdirectories() {
        return this.mIncludeSubdirectories;
    }

    public Boolean getFollowSymbolicLinks() {
        return this.mFollowSymbolicLinks;
    }

    public void setFollowSymbolicLinks(Boolean inValue) {
        this.mFollowSymbolicLinks = inValue;
    }

    public Boolean getUseMiniPlans() {
        return this.mUseMiniPlans;
    }

    public void setUseMiniPlans(Boolean inUseMiniPlans) {
        this.mUseMiniPlans = inUseMiniPlans;
    }

    public Boolean getUseSamePrepareSteps() {
        return this.mUseSamePrepareSteps;
    }

    public void setUseSamePrepareSteps(Boolean inUseSamePrepareSteps) {
        this.mUseSamePrepareSteps = inUseSamePrepareSteps;
    }

    public ReaderWrapper getSrcPrepareSteps() {
        return this.mSrcPrepareSteps;
    }

    public void setSrcPrepareSteps(ReaderWrapper inSrcPrepareSteps) {
        this.mSrcPrepareSteps = inSrcPrepareSteps;
        this.mCloser.register(this.mSrcPrepareSteps);
    }

    public ReaderWrapper getDstPrepareSteps() {
        return this.mDstPrepareSteps;
    }

    public void setDstPrepareSteps(ReaderWrapper inDstPrepareSteps) {
        this.mDstPrepareSteps = inDstPrepareSteps;
        this.mCloser.register(this.mDstPrepareSteps);
    }

    public Boolean getUseSameCleanupSteps() {
        return this.mUseSameCleanupSteps;
    }

    public void setUseSameCleanupSteps(Boolean inUseSameCleanupSteps) {
        this.mUseSameCleanupSteps = inUseSameCleanupSteps;
    }

    public ReaderWrapper getSrcCleanupSteps() {
        return this.mSrcCleanupSteps;
    }

    public void setSrcCleanupSteps(ReaderWrapper inSrcCleanupSteps) {
        this.mSrcCleanupSteps = inSrcCleanupSteps;
        this.mCloser.register(this.mSrcCleanupSteps);
    }

    public ReaderWrapper getDstCleanupSteps() {
        return this.mDstCleanupSteps;
    }

    public void setDstCleanupSteps(ReaderWrapper inDstCleanupSteps) {
        this.mDstCleanupSteps = inDstCleanupSteps;
        this.mCloser.register(this.mDstCleanupSteps);
    }

    protected void setDifferenceSettings(DifferenceSettings s, int inMode) throws Exception {
        if (this.getName() != null) {
            s.setName(this.getName());
        }
        if (this.getDescription() != null) {
            s.setDescription(this.getDescription());
        }
        if (this.getStyle() != null) {
            s.setDiffStyle(this.getStyle().getValue());
            s.setSrcHostID(null);
            s.setDstHostID(null);
            s.setDstHostSetID(null);
            s.setSrcDir(null);
            s.setDstDir(null);
            s.setInstalledComponentID(null);
        }
        if (this.getLevel() != null) {
            s.setDiffLevel(this.getLevel().getValue());
        }
        if (this.getScope() != null) {
            s.setDiffScope(this.getScope().getValue());
            s.setDstHostID(null);
            s.setDstHostSetID(null);
            s.setInstalledComponentID(null);
        }
        if (this.getSrcHostID() != null) {
            s.setSrcHostID(this.getSrcHostID().toString());
        }
        if (this.getDstHostID() != null) {
            s.setDstHostID(this.getDstHostID().toString());
        }
        if (this.getDstHostSetID() != null) {
            s.setDstHostSetID(this.getDstHostSetID().toString());
        }
        if (this.getSrcDir() != null) {
            if (s.getDiffStyle() != 2) {
                throw PackageInfo.createInvalidArgument();
            }
            s.setSrcDir(this.getSrcDir());
        }
        if (this.getDstDir() != null) {
            if (s.getDiffStyle() != 2) {
                throw PackageInfo.createInvalidArgument();
            }
            s.setDstDir(this.getDstDir());
        }
        if (this.getIgnorePaths() != null) {
            if (s.getDiffStyle() == 0) {
                throw PackageInfo.createInvalidArgument();
            }
            s.setIgnorePaths(this.getIgnorePaths());
        }
        if (this.getInstalledComponentRef() != null) {
            if (s.getDiffStyle() != 1 || s.getDiffScope() != 0) {
                throw PackageInfo.createInvalidArgument();
            }
            if (s.getDstHostID() == null) {
                throw PackageInfo.createInvalidArgument();
            }
            InstalledComponent[] result = MultiInstalledComponentQuery.byCompRef(new HostID(s.getDstHostID()), TargetType.CURRENT, this.getInstalledComponentRef(), null).selectICView();
            if (result.length == 0) {
                throw PackageInfo.createComponentNone();
            }
            if (result.length > 1) {
                throw PackageInfo.createComponentMany();
            }
            s.setInstalledComponentID(result[0].getID());
        }
        if (this.getTimeoutSecs() != null) {
            if (this.getTimeoutSecs().isIndefinite()) {
                s.setTimeoutSecs(-1);
            } else {
                s.setTimeoutSecs((int)this.getTimeoutSecs().convertRound(1));
            }
        }
        if (this.getIncludeSubdirectories() != null) {
            if (s.getDiffStyle() != 2) {
                throw PackageInfo.createInvalidArgument();
            }
            s.setIncludeSubdirectories(this.getIncludeSubdirectories());
        }
        if (this.getFollowSymbolicLinks() != null) {
            if (s.getDiffStyle() != 2) {
                throw PackageInfo.createInvalidArgument();
            }
            s.setFollowSymlinks(this.getFollowSymbolicLinks());
        }
        if (s.getDiffStyle() == 2) {
            s.setDiffScope(2);
        }
        if (s.getDiffStyle() == 0) {
            s.setDiffLevel(0);
            s.setDiffScope(2);
        }
        if (s.getDiffStyle() == 2 && (inMode != 1 || this.getUseMiniPlans() != null)) {
            if (this.getUseMiniPlans() != null && this.getUseMiniPlans().booleanValue()) {
                s.setUseMiniPlans(true);
                String ts = this.readerWrapper2String(this.getSrcPrepareSteps(), "srcP");
                if (ts.equals("")) {
                    throw PackageInfo.createMissingArgument("srcP");
                }
                s.setSrcPrepare(ts);
                if (this.getUseSamePrepareSteps() != null && !this.getUseSamePrepareSteps().booleanValue()) {
                    s.setDstUseSrcP(false);
                    ts = this.readerWrapper2String(this.getDstPrepareSteps(), "dstP");
                    if (ts.equals("")) {
                        throw PackageInfo.createMissingArgument("dstP");
                    }
                    s.setDstPrepare(ts);
                } else {
                    s.setDstUseSrcP(true);
                    s.setDstPrepare(ts);
                }
                ts = this.readerWrapper2String(this.getSrcCleanupSteps(), "srcC");
                if (ts.equals("")) {
                    throw PackageInfo.createMissingArgument("srcC");
                }
                s.setSrcCleanup(ts);
                if (this.getUseSameCleanupSteps() != null && !this.getUseSameCleanupSteps().booleanValue()) {
                    s.setDstUseSrcC(false);
                    ts = this.readerWrapper2String(this.getDstCleanupSteps(), "dstC");
                    if (ts.equals("")) {
                        throw PackageInfo.createMissingArgument("dstC");
                    }
                    s.setDstCleanup(ts);
                } else {
                    s.setDstUseSrcC(true);
                    s.setDstCleanup(ts);
                }
            } else {
                s.setUseMiniPlans(false);
                s.setDstUseSrcP(true);
                s.setSrcPrepare("");
                s.setDstPrepare("");
                s.setDstUseSrcC(true);
                s.setSrcCleanup("");
                s.setDstCleanup("");
            }
        }
    }

    public void cleanup() {
        super.cleanup();
        this.mCloser.closeAll();
    }
}

