/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.difference.commands;

import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceJobID;
import com.raplix.rolloutexpress.difference.IIDifferencePath;
import com.raplix.rolloutexpress.difference.MIDifferencePath;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettings;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceAbortEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceAbortRequestedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceCompleteEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFailedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceFoundEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceJobFailedEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceProgressEvent;
import com.raplix.rolloutexpress.event.ROXDifferenceStartEvent;
import com.raplix.rolloutexpress.event.ROXEventID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.difference.formatters.DifferenceUtil;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class DifferenceJobView
extends SessionBase
implements OutputCommand {
    private static final String PATH_SEPARATOR = ":";
    private static final long POLL_DELAY = 5000L;
    private static final long QUERY_LAG = 10000L;
    private static final String COMMA_SEPARATOR = ",";
    private static CommandHelp sHelp = new DifferenceJobViewHelp();
    private static final String HEADER_PREFIX = "ui.cmp.dj.lo";
    private static final String MSG_START_HEADER = "ui.cmp.dj.lo.START_HEADER";
    private static final String MSG_PROGRESS_HEADER = "ui.cmp.dj.lo.PROGRESS_HEADER";
    private static final String MSG_COMPLETE_HEADER = "ui.cmp.dj.lo.COMPLETE_HEADER";
    private static final String MSG_ABORT_HEADER = "ui.cmp.dj.lo.ABORT_HEADER";
    private static final String MSG_JOB_FAILED_HEADER = "ui.cmp.dj.lo.JOB_FAILED_HEADER";
    private static final String MSG_ABORT_REQUESTED_HEADER = "ui.cmp.dj.lo.ABORT_REQUESTED_HEADER";
    private static final String MSG_FAILURE_HEADER = "ui.cmp.dj.lo.FAILURE_HEADER";
    private static final String MSG_DIFFERENCE_HEADER = "ui.cmp.dj.lo.DIFFERENCE_HEADER";
    private static final String MSG_SETTINGS_HEADER = "ui.cmp.dj.lo.SETTINGS_HEADER";
    private DifferenceJobID mID;
    private boolean mShowOld;
    private boolean mFollow = true;
    private OutputStream mOutputStream;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$difference$commands$DifferenceJobView;
    static /* synthetic */ Class class$java$lang$String;

    public void setOutputStream(OutputStream stream) {
        this.mOutputStream = stream;
    }

    public void setID(DifferenceJobID ID2) {
        this.mID = ID2;
    }

    public DifferenceJobID getID() {
        return this.mID;
    }

    public void setShowOld(boolean showOld) {
        this.mShowOld = showOld;
    }

    public boolean getShowOld() {
        return this.mShowOld;
    }

    public void setFollow(boolean follow) {
        this.mFollow = follow;
    }

    public boolean getFollow() {
        return this.mFollow;
    }

    private void printDifferencePath(PrintWriter pw, ROXDifferenceFoundEvent ev, DifferenceSettings ds) {
        switch (ds.getDiffStyle()) {
            case 0: {
                pw.println("");
                break;
            }
            case 1: {
                MIDifferencePath midp = new MIDifferencePath();
                midp.inflate(ev.getDifferencePath());
                pw.print(midp.getHostName());
                pw.print(PATH_SEPARATOR);
                pw.print(midp.getComponentName());
                pw.print(PATH_SEPARATOR);
                if (midp.getDisplayName() != null) {
                    pw.println(midp.getDisplayName());
                    break;
                }
                pw.println(midp.getFilePath());
                break;
            }
            case 2: {
                IIDifferencePath iidp = new IIDifferencePath();
                iidp.inflate(ev.getDifferencePath());
                String filePath = iidp.getFilePath();
                pw.println(filePath);
            }
        }
    }

    private void printICID(PrintWriter pw, String icID) throws Exception {
        pw.print(DifferenceUtil.format(new InstalledComponentID(icID)));
    }

    private void printICIDs(PrintWriter pw, String icIDs) throws Exception {
        StringTokenizer st = new StringTokenizer(icIDs, COMMA_SEPARATOR);
        while (st.hasMoreTokens()) {
            String icID = st.nextToken();
            this.printICID(pw, icID);
            if (!st.hasMoreTokens()) continue;
            pw.print(" ");
        }
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        if (this.mOutputStream == null) {
            this.setOutputStream(System.out);
        }
        long nextStart = this.getShowOld() ? 0L : System.currentTimeMillis();
        NotificationRPCInterface notification = Context.getNotificationRPCInterface();
        Vector<ROXDifferenceEvent> prototypes = new Vector<ROXDifferenceEvent>();
        prototypes.addElement(new ROXDifferenceFoundEvent());
        prototypes.addElement(new ROXDifferenceProgressEvent());
        prototypes.addElement(new ROXDifferenceAbortEvent());
        prototypes.addElement(new ROXDifferenceAbortRequestedEvent());
        prototypes.addElement(new ROXDifferenceStartEvent());
        prototypes.addElement(new ROXDifferenceCompleteEvent());
        ROXDifferenceFailedEvent rdfe = new ROXDifferenceFailedEvent();
        rdfe.setSeverity(0);
        prototypes.addElement(rdfe);
        prototypes.addElement(new ROXDifferenceJobFailedEvent());
        Enumeration e = prototypes.elements();
        while (e.hasMoreElements()) {
            ((ROXDifferenceEvent)e.nextElement()).setDifferenceJobID(this.getID());
        }
        PrintWriter pw = new PrintWriter(this.mOutputStream);
        HashSet<ROXEventID> seen = new HashSet<ROXEventID>();
        double lastProgress = -1.0;
        while (true) {
            Vector matches;
            try {
                matches = notification.query(prototypes);
            }
            catch (EmptyQueryException e2) {
                matches = new Vector();
            }
            DifferenceSettings ds = null;
            Enumeration e3 = matches.elements();
            while (e3.hasMoreElements()) {
                long timeStamp;
                ROXDifferenceEvent ev;
                if (ds == null) {
                    ROXDifferenceEvent evt = (ROXDifferenceEvent)matches.firstElement();
                    ds = Context.getDifferenceDBInterface().getDifferenceSettings(evt.getDifferenceSettingsID());
                }
                if (seen.contains((ev = (ROXDifferenceEvent)e3.nextElement()).getEventID())) continue;
                if (ev instanceof ROXDifferenceStartEvent) {
                    seen.add(ev.getEventID());
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.print(Context.getMessageText(MSG_START_HEADER));
                    pw.print(": ");
                    pw.print(Context.getMessageText(MSG_SETTINGS_HEADER));
                    pw.println(':');
                    DifferenceUtil.write(pw, ds, " ");
                } else if (ev instanceof ROXDifferenceCompleteEvent) {
                    seen.add(ev.getEventID());
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.println(Context.getMessageText(MSG_COMPLETE_HEADER));
                    this.setFollow(false);
                } else if (ev instanceof ROXDifferenceAbortEvent) {
                    seen.add(ev.getEventID());
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.println(Context.getMessageText(MSG_ABORT_HEADER));
                } else if (ev instanceof ROXDifferenceJobFailedEvent) {
                    seen.add(ev.getEventID());
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.println(Context.getMessageText(MSG_JOB_FAILED_HEADER));
                } else if (ev instanceof ROXDifferenceAbortRequestedEvent) {
                    seen.add(ev.getEventID());
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.println(Context.getMessageText(MSG_ABORT_REQUESTED_HEADER));
                } else if (ev instanceof ROXDifferenceProgressEvent) {
                    ROXDifferenceProgressEvent pEv = (ROXDifferenceProgressEvent)ev;
                    if (pEv.getProgress() > lastProgress) {
                        lastProgress = pEv.getProgress();
                        pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                        pw.print(' ');
                        pw.print(Context.getMessageText(MSG_PROGRESS_HEADER));
                        pw.print(": ");
                        pw.print(lastProgress);
                        pw.println('%');
                    }
                } else if (ev instanceof ROXDifferenceFailedEvent) {
                    seen.add(ev.getEventID());
                    ROXDifferenceFailedEvent fEv = (ROXDifferenceFailedEvent)ev;
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.print(Context.getMessageText(MSG_FAILURE_HEADER));
                    pw.println(": ");
                    pw.print(' ');
                    pw.println(fEv.formatMessage());
                    pw.println(fEv.getExceptionDescription());
                } else if (ev instanceof ROXDifferenceFoundEvent) {
                    seen.add(ev.getEventID());
                    ROXDifferenceFoundEvent fEv = (ROXDifferenceFoundEvent)ev;
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.print(Context.getMessageText(MSG_DIFFERENCE_HEADER));
                    pw.print(": ");
                    this.printDifferencePath(pw, fEv, ds);
                    pw.print(' ');
                    Difference d = fEv.getDifference();
                    switch (d.getType()) {
                        case 400: {
                            pw.print("module not loaded in ");
                            if (d.getSourceVal() != null) {
                                pw.println("destination: " + d.getSourceVal());
                            } else {
                                pw.println("source: " + d.getDestVal());
                            }
                            pw.println();
                            break;
                        }
                        case 401: {
                            pw.println("module locations differ");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 402: {
                            pw.print("directive missing from ");
                            if (d.getDestVal() != null) {
                                pw.println("source: " + d.getDestVal());
                            } else {
                                pw.println("destination: " + d.getSourceVal());
                            }
                            pw.println();
                            break;
                        }
                        case 403: {
                            pw.println("directive mismatch");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 404: {
                            pw.print("configuration group missing in ");
                            if (d.getDestVal() != null) {
                                pw.println("source: " + d.getDestVal());
                            } else {
                                pw.println("destination: " + d.getSourceVal());
                            }
                            pw.println();
                            break;
                        }
                        case 405: {
                            pw.print("group directive missing in ");
                            if (d.getDestVal() != null) {
                                pw.println("source: " + d.getDestVal());
                            } else {
                                pw.println("destination: " + d.getSourceVal());
                            }
                            pw.println();
                            break;
                        }
                        case 406: {
                            pw.println("group directive mismatch");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 300: {
                            pw.println("files are different lengths");
                            pw.println();
                            break;
                        }
                        case 301: {
                            pw.println("files binaries are different. first changed byte: #" + d.getSourceOrder());
                            pw.println();
                            break;
                        }
                        case 302: {
                            pw.println("files lengths and binaries are different. first changed byte: #" + d.getSourceOrder());
                            pw.println();
                            break;
                        }
                        case 500: {
                            if (d.getSourceVal() == null) {
                                pw.print(d.getIdentifier());
                                pw.println(": missing from source " + d.getDestVal() + "(#" + d.getDestOrder() + ")");
                                pw.println();
                                break;
                            }
                            if (d.getDestVal() == null) {
                                pw.print(d.getIdentifier());
                                pw.println(": missing from destination " + d.getSourceVal() + "(#" + d.getSourceOrder() + ")");
                                pw.println();
                                break;
                            }
                            pw.print(d.getIdentifier());
                            pw.print(": source is \"" + d.getSourceVal() + "\"(#" + d.getSourceOrder() + ")");
                            pw.println(", destination is \"" + d.getDestVal() + "\"(#" + d.getDestOrder() + ")");
                            pw.println();
                            break;
                        }
                        case 0: {
                            pw.print("file missing from ");
                            if (d.getSourceVal() != null) {
                                pw.println("destination: " + d.getSourceVal());
                            } else {
                                pw.println("source: " + d.getDestVal());
                            }
                            pw.println();
                            break;
                        }
                        case 9: {
                            pw.print("symbolic link missing from ");
                            if (d.getSourceVal() != null) {
                                pw.println("destination: " + d.getSourceVal());
                            } else {
                                pw.println("source: " + d.getDestVal());
                            }
                            pw.println();
                            break;
                        }
                        case 1: {
                            pw.print("directory missing from ");
                            if (d.getSourceVal() != null) {
                                pw.println("destination: " + d.getSourceVal());
                            } else {
                                pw.println("source: " + d.getDestVal());
                            }
                            pw.println();
                            break;
                        }
                        case 2: {
                            pw.println("files sizes are different");
                            pw.println("source: " + d.getSourceOrder());
                            pw.println("destination: " + d.getDestOrder());
                            pw.println();
                            break;
                        }
                        case 10: {
                            pw.println("symbolic links point to different files or directories");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 3: {
                            pw.print("Component absent from ");
                            if (d.getSourceVal() != null) {
                                pw.print("destination: ");
                                this.printICID(pw, d.getSourceVal());
                            } else {
                                pw.print("source: ");
                                this.printICID(pw, d.getDestVal());
                            }
                            pw.println();
                            pw.println();
                            break;
                        }
                        case 4: {
                            pw.print("Component absent at ");
                            if (d.getSourceVal() != null) {
                                pw.print("source path in destination: ");
                                this.printICID(pw, d.getSourceVal());
                            } else {
                                pw.print("destination path in source: ");
                                this.printICID(pw, d.getDestVal());
                            }
                            pw.println();
                            pw.println();
                            break;
                        }
                        case 5: {
                            pw.print("Component version mismatch: ");
                            this.printICID(pw, d.getSourceVal());
                            pw.print(" in source, ");
                            this.printICID(pw, d.getDestVal());
                            pw.println(" in destination");
                            pw.println();
                            break;
                        }
                        case 7: {
                            pw.print("Ownership changed from installed component ");
                            this.printICID(pw, d.getSourceVal());
                            pw.print(" in source to ");
                            this.printICIDs(pw, d.getDestVal());
                            pw.println(" in destination");
                            pw.println();
                            break;
                        }
                        case 6: {
                            pw.println("text file differences");
                            pw.println();
                            break;
                        }
                        case 8: {
                            pw.println("text file differences");
                            pw.println();
                            break;
                        }
                        case 200: {
                            pw.print("key missing in ");
                            if (d.getSourceVal() != null) {
                                pw.println("destination: " + d.getSourceVal());
                            } else {
                                pw.println("source: " + d.getDestVal());
                            }
                            pw.println();
                            break;
                        }
                        case 201: {
                            pw.print("missing values for key in ");
                            if (d.getSourceVal() != null) {
                                pw.println("destination: " + d.getSourceVal());
                            } else {
                                pw.println("source: " + d.getDestVal());
                            }
                            pw.println();
                            break;
                        }
                        case 202: {
                            pw.print("value type mismatch (String vs. List) on key: ");
                            pw.println(d.getSourceVal());
                            pw.println();
                            break;
                        }
                        case 203: {
                            pw.println("value mismatch");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 600: {
                            if (d.getSourceVal() == null) {
                                pw.print(d.getIdentifier());
                                pw.println(": missing from source " + d.getDestVal());
                                pw.println();
                                break;
                            }
                            if (d.getDestVal() == null) {
                                pw.print(d.getIdentifier());
                                pw.println(": missing from destination " + d.getSourceVal());
                                pw.println();
                                break;
                            }
                            pw.print(d.getIdentifier() + " differs");
                            pw.print(": source is \"" + d.getSourceVal() + "\"");
                            pw.println(", destination is \"" + d.getDestVal() + "\"");
                            pw.println();
                            break;
                        }
                        case 100: {
                            pw.print("attribute missing in ");
                            if (d.getDestVal() != null) {
                                pw.println("source: " + d.getDestVal());
                            } else {
                                pw.println("destination: " + d.getSourceVal());
                            }
                            pw.println();
                            break;
                        }
                        case 101: {
                            pw.println("attribute mismatch");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 102: {
                            pw.print("node missing from ");
                            if (d.getDestVal() != null) {
                                pw.println("source: " + d.getDestVal());
                            } else {
                                pw.println("destination: " + d.getSourceVal());
                            }
                            pw.println();
                            break;
                        }
                        case 103: {
                            pw.println("different node names");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 104: {
                            pw.println("different node types");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        case 105: {
                            pw.println("different node values");
                            pw.println("source: " + d.getSourceVal());
                            pw.println("destination: " + d.getDestVal());
                            pw.println();
                            break;
                        }
                        default: {
                            pw.println(d);
                            pw.println();
                            throw new IllegalArgumentException("Invalid type: " + d.getType());
                        }
                    }
                } else {
                    seen.add(ev.getEventID());
                    pw.print(Context.getConverterHandler().convert(ev.getDate(), class$java$lang$String == null ? DifferenceJobView.class$("java.lang.String") : class$java$lang$String));
                    pw.print(' ');
                    pw.println(ev.getMessage());
                }
                if ((timeStamp = ev.getDate().getTime() - 10000L) <= nextStart) continue;
                nextStart = timeStamp;
            }
            pw.flush();
            if (!this.getFollow()) break;
            Thread.sleep(5000L);
        }
    }

    protected static class DifferenceJobViewHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cmp.dj.lo";
        private static final String MSG_ID_DESC = "KEY:ui.cmp.dj.lo.ID_DESC";
        private static final String MSG_OLD_DESC = "KEY:ui.cmp.dj.lo.OLD_DESC";
        private static final String MSG_NEW_DESC = "KEY:ui.cmp.dj.lo.NEW_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.cmp.dj.lo.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("ID", MSG_ID_DESC));
            map.addElement(new CommandHelpBase.OptionalArgInfo("showOld", MSG_OLD_DESC, "old"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("follow", MSG_NEW_DESC, "new"));
            return map;
        }

        DifferenceJobViewHelp() {
            super(class$com$raplix$rolloutexpress$ui$difference$commands$DifferenceJobView == null ? (class$com$raplix$rolloutexpress$ui$difference$commands$DifferenceJobView = DifferenceJobView.class$("com.raplix.rolloutexpress.ui.difference.commands.DifferenceJobView")) : class$com$raplix$rolloutexpress$ui$difference$commands$DifferenceJobView, MSG_COMMAND_DESC);
        }
    }
}

