/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.converters;

import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.PackageInfo;
import com.raplix.rolloutexpress.ui.converters.String2Date;
import com.raplix.rolloutexpress.ui.converters.String2Long;
import com.raplix.rolloutexpress.ui.converters.TimeInterval;
import com.raplix.rolloutexpress.ui.converters.TimeIntervalBase;
import com.raplix.util.TimeUtil;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;
import java.text.ParseException;

public class String2TimeInterval
extends TimeIntervalBase
implements Converter {
    private static final String PATTERN_GENERIC = "^((\\d+)w)?((\\d+)d)?((\\d+):)?(\\d+)(\\.(\\d+)(\\.(\\d+))?)?$";
    private static final String PATTERN_TAGS = "^((\\d+)w)?((\\d+)d)?((\\d+)h)?((\\d+)m)?((\\d+)s)?((\\d+)ms)?$";
    private String2Date mString2Date = new String2Date();

    public void setString2Date(String2Date string2Date) {
        this.mString2Date = string2Date;
    }

    public String2Date getString2Date() {
        return this.mString2Date;
    }

    public TimeInterval convert(String src) throws ParseException {
        if ("-".equals(src)) {
            return new TimeInterval();
        }
        if (src.startsWith("@")) {
            long ms = this.getString2Date().convert(src.substring("@".length())).getTime() - System.currentTimeMillis();
            if (ms < 0L) {
                return new TimeInterval();
            }
            return new TimeInterval(ms, 0);
        }
        long w = 0L;
        long d = 0L;
        long h = 0L;
        long m = 0L;
        long s = 0L;
        long ms = 0L;
        RegEx re = null;
        try {
            re = new RegEx(PATTERN_GENERIC);
        }
        catch (RegExSyntaxException ex) {
            // empty catch block
        }
        if (re.match(src)) {
            if (re.getParenCount() >= 3 && re.getParen(2) != null) {
                w = String2Long.convert(re.getParen(2));
            }
            if (re.getParenCount() >= 5 && re.getParen(4) != null) {
                d = String2Long.convert(re.getParen(4));
            }
            if (re.getParenCount() >= 7 && re.getParen(6) != null) {
                h = String2Long.convert(re.getParen(6));
            }
            if (re.getParenCount() >= 8 && re.getParen(7) != null) {
                m = String2Long.convert(re.getParen(7));
            }
            if (re.getParenCount() >= 10 && re.getParen(9) != null) {
                s = String2Long.convert(re.getParen(9));
            }
            if (re.getParenCount() >= 12 && re.getParen(11) != null) {
                ms = String2Long.convert(re.getParen(11));
            }
        } else {
            try {
                re = new RegEx(PATTERN_TAGS);
            }
            catch (RegExSyntaxException ex) {
                // empty catch block
            }
            if (re.match(src)) {
                if (re.getParenCount() >= 3 && re.getParen(2) != null) {
                    w = String2Long.convert(re.getParen(2));
                }
                if (re.getParenCount() >= 5 && re.getParen(4) != null) {
                    d = String2Long.convert(re.getParen(4));
                }
                if (re.getParenCount() >= 7 && re.getParen(6) != null) {
                    h = String2Long.convert(re.getParen(6));
                }
                if (re.getParenCount() >= 9 && re.getParen(8) != null) {
                    m = String2Long.convert(re.getParen(8));
                }
                if (re.getParenCount() >= 11 && re.getParen(10) != null) {
                    s = String2Long.convert(re.getParen(10));
                }
                if (re.getParenCount() >= 13 && re.getParen(12) != null) {
                    ms = String2Long.convert(re.getParen(12));
                }
            } else {
                PackageInfo.throwBadFormat(src);
            }
        }
        return new TimeInterval(TimeUtil.convert(w, 5, 0) + TimeUtil.convert(d, 4, 0) + TimeUtil.convert(h, 3, 0) + TimeUtil.convert(m, 2, 0) + TimeUtil.convert(s, 1, 0) + TimeUtil.convert(ms, 0, 0), 0);
    }
}

