/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.converters;

import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.ConverterHandler;
import com.raplix.rolloutexpress.ui.converters.ConverterWrapper;
import com.raplix.rolloutexpress.ui.converters.PackageInfo;
import com.raplix.util.reflect.ClassUtil;
import java.util.Enumeration;
import java.util.Vector;

public abstract class RepositoryHandlerBase
implements ConverterHandler {
    private Vector mConverters = new Vector();

    protected ConverterWrapper search(Class srcClass, Class dstClass) {
        srcClass = ClassUtil.getObjectClass(srcClass);
        dstClass = ClassUtil.getObjectClass(dstClass);
        Enumeration e = this.mConverters.elements();
        while (e.hasMoreElements()) {
            ConverterWrapper w = (ConverterWrapper)e.nextElement();
            if (!w.matches(srcClass, dstClass)) continue;
            return w;
        }
        return null;
    }

    protected abstract ConverterWrapper find(Class var1, Class var2);

    public void addConverter(ConverterWrapper w) {
        this.mConverters.addElement(w);
    }

    public void addConverter(Converter c) {
        this.addConverter(new ConverterWrapper(c));
    }

    public Object convert(Object src, Class dstClass) throws Exception {
        Class<?> srcClass = src.getClass();
        ConverterWrapper w = this.find(srcClass, dstClass);
        if (w != null) {
            return w.apply(src);
        }
        PackageInfo.throwConverterNotFound(srcClass, dstClass);
        return null;
    }
}

