/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.converters;

import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterNotFoundException;
import java.text.ParseException;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "ui.converters";
    public static final String EX_SIGNATURE_MISMATCH = "ui.converters.EX_SIGNATURE_MISMATCH";
    public static final String EX_SIGNATURE_MISMATCH_VOID = "ui.converters.EX_SIGNATURE_MISMATCH_VOID";
    public static final String EX_CONVERTER_NOT_FOUND = "ui.converters.EX_CONVERTER_NOT_FOUND";
    public static final String EX_UNKNOWN_FORMAT = "ui.converters.EX_UNKNOWN_FORMAT";
    public static final String EX_NUMBER_FORMAT = "ui.converters.EX_NUMBER_FORMAT";

    private PackageInfo() {
    }

    public static void throwSignatureMismatch() {
        throw new IllegalArgumentException(Context.getMessageText(EX_SIGNATURE_MISMATCH_VOID, "convert"));
    }

    public static void throwSignatureMismatch(int count) {
        throw new IllegalArgumentException(Context.getMessageText(EX_SIGNATURE_MISMATCH, "convert", new Integer(count)));
    }

    public static void throwConverterNotFound(Class srcClass, Class dstClass) throws ConverterNotFoundException {
        throw new ConverterNotFoundException(Context.getMessageText(EX_CONVERTER_NOT_FOUND, srcClass.getName(), dstClass.getName()));
    }

    public static void throwBadFormat(String str) throws ParseException {
        throw new ParseException(Context.getMessageText(EX_UNKNOWN_FORMAT, str), -1);
    }

    public static void throwNumberFormat(String str) throws NumberFormatException {
        throw new NumberFormatException(Context.getMessageText(EX_NUMBER_FORMAT, str));
    }
}

