/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.converters;

import com.raplix.rolloutexpress.ui.converters.String2StringArray;
import com.raplix.util.collections.CollectionUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public abstract class MapConverter {
    protected static final String PAIR_DELIMITERS = ";";
    protected static final String KEY_VALUE_DELIMITERS = "=";
    protected static final String STRING_ARRAY_PREFIX = "[]";
    protected static final String STRING_ARRAY_DELIMITERS = ",";
    protected static final String MAP_BEGIN_DELIMITERS = "{";
    protected static final String MAP_END_DELIMITERS = "}";
    protected static final MapEscape ESCAPE = new MapEscape();

    public String convert(Map src) {
        char kvd = KEY_VALUE_DELIMITERS.charAt(0);
        char sad = STRING_ARRAY_DELIMITERS.charAt(0);
        char pd = PAIR_DELIMITERS.charAt(0);
        StringBuffer buffer = new StringBuffer();
        Iterator itr = src.keySet().iterator();
        while (itr.hasNext()) {
            Object key = itr.next();
            buffer.append(ESCAPE.escape(key.toString()));
            buffer.append(kvd);
            Object value = src.get(key);
            if (value instanceof Map) {
                buffer.append(MAP_BEGIN_DELIMITERS);
                buffer.append(this.convert((Map)value));
                buffer.append(MAP_END_DELIMITERS);
            } else if (CollectionUtil.isEnumerable(value)) {
                buffer.append(STRING_ARRAY_PREFIX);
                Enumeration e = CollectionUtil.getEnumeration(value);
                while (e.hasMoreElements()) {
                    buffer.append(ESCAPE.escape(e.nextElement().toString()));
                    if (!e.hasMoreElements()) continue;
                    buffer.append(sad);
                }
            } else {
                buffer.append(ESCAPE.escape(value.toString()));
            }
            if (!itr.hasNext()) continue;
            buffer.append(pd);
        }
        return buffer.toString();
    }

    public Map convert(String src) {
        Map result = this.createMap();
        String2StringArray c = new String2StringArray();
        c.setDelimiters(PAIR_DELIMITERS);
        String[] pairs = c.convert(src);
        c.setDelimiters(STRING_ARRAY_DELIMITERS);
        for (int i = 0; i < pairs.length; ++i) {
            int s = pairs[i].indexOf(KEY_VALUE_DELIMITERS);
            if (s == -1) {
                result.put(pairs[i], "");
                continue;
            }
            String key = ESCAPE.unescape(pairs[i].substring(0, s).trim());
            String value = pairs[i].substring(s + 1).trim();
            if (!value.startsWith(STRING_ARRAY_PREFIX)) {
                if (!value.startsWith(MAP_BEGIN_DELIMITERS)) {
                    result.put(key, ESCAPE.unescape(value));
                    continue;
                }
                while (!value.endsWith(MAP_END_DELIMITERS)) {
                    if (i >= pairs.length - 1) {
                        return null;
                    }
                    value = value + PAIR_DELIMITERS + pairs[++i].trim();
                }
                Map subMap = this.convert(value.substring(1, value.length() - 1));
                if (subMap == null) {
                    return null;
                }
                result.put(key, subMap);
                continue;
            }
            String[] arrayValues = c.convert(value.substring(STRING_ARRAY_PREFIX.length()));
            for (int j = 0; j < arrayValues.length; ++j) {
                arrayValues[j] = ESCAPE.unescape(arrayValues[j]);
            }
            result.put(key, arrayValues);
        }
        return result;
    }

    protected abstract Map createMap();

    protected static class MapEscape
    extends com.raplix.util.string.MapEscape {
        private static final Hashtable ESCAPE_MAP = new Hashtable();
        private static final Hashtable UNESCAPE_MAP = new Hashtable();

        protected MapEscape() {
        }

        private static void addToMap(String str, String escape) {
            ESCAPE_MAP.put(str, escape);
            UNESCAPE_MAP.put(escape, str);
        }

        protected Hashtable getEscapeMap() {
            return ESCAPE_MAP;
        }

        protected Hashtable getUnescapeMap() {
            return UNESCAPE_MAP;
        }

        static {
            MapEscape.addToMap("%", "%25");
            MapEscape.addToMap("[", "%5B");
            MapEscape.addToMap("]", "%5D");
            MapEscape.addToMap(MapConverter.MAP_BEGIN_DELIMITERS, "%7B");
            MapEscape.addToMap(MapConverter.MAP_END_DELIMITERS, "%7D");
            MapEscape.addToMap(MapConverter.KEY_VALUE_DELIMITERS, "%3D");
            MapEscape.addToMap(MapConverter.PAIR_DELIMITERS, "%3B");
            MapEscape.addToMap(" ", "%20");
        }
    }
}

