/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.converters;

import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.converters.PackageInfo;
import com.raplix.util.logger.Logger;
import com.raplix.util.reflect.ClassUtil;
import com.raplix.util.reflect.MethodUtil;
import java.lang.reflect.Method;

public class ConverterWrapper {
    private Class mSrcClass;
    private Class mDstClass;
    private Converter mConverter;
    private Method mMethod;

    public ConverterWrapper(Converter converter) {
        Class<?>[] param;
        this.mConverter = converter;
        this.mMethod = MethodUtil.findMethod(this.mConverter.getClass(), "convert");
        Class<?> returns = this.mMethod.getReturnType();
        if (returns.equals(ClassUtil.VOID_OBJ_CLS) || returns.equals(ClassUtil.VOID_PRM_CLS)) {
            PackageInfo.throwSignatureMismatch();
        }
        if ((param = this.mMethod.getParameterTypes()).length != 1) {
            PackageInfo.throwSignatureMismatch(param.length);
        }
        this.mSrcClass = ClassUtil.getObjectClass(param[0]);
        this.mDstClass = ClassUtil.getObjectClass(this.mMethod.getReturnType());
    }

    public ConverterWrapper(Class converterClass) {
        this((Converter)ClassUtil.createObject(converterClass, Converter.class));
    }

    public boolean matches(Class srcClass, Class dstClass) {
        return this.mSrcClass.isAssignableFrom(srcClass) && dstClass.isAssignableFrom(this.mDstClass);
    }

    public Object apply(Object src) throws Exception {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Applying '" + this.mConverter + "' to '" + src + "'", this);
        }
        return MethodUtil.invokeMember(this.mMethod, this.mConverter, src);
    }
}

