/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.converters;

import [Ljava.lang.Object;;
import com.raplix.rolloutexpress.ui.ConverterHandler;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Mapper;

public class CollectionHandler
implements ConverterHandler {
    private ConverterHandler mElementHandler;

    public CollectionHandler(ConverterHandler elementHandler) {
        this.mElementHandler = elementHandler;
    }

    public Object convert(Object src, Class dstClass) throws Exception {
        if (!CollectionUtil.isEnumerable(src)) {
            src = this.mElementHandler.convert(src, Object;.class);
        }
        src = CollectionUtil.mapClass(src, dstClass, new ConverterMapper());
        if (!CollectionUtil.isEnumerableClass(dstClass)) {
            src = this.mElementHandler.convert(src, dstClass);
        }
        return src;
    }

    private class ConverterMapper
    implements Mapper {
        private Class mDstClass;

        private ConverterMapper() {
        }

        public void setMappedClass(Class dstClass) {
            this.mDstClass = dstClass;
        }

        public Object map(Object element) throws Exception {
            if (this.mDstClass == null) {
                return element;
            }
            return CollectionHandler.this.mElementHandler.convert(element, this.mDstClass);
        }
    }
}

