/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.config.commands;

import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.RemoteConfigGenManager;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.OutputCommand;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.ReaderWrapper;
import com.raplix.util.unicode.UnicodeOutputStreamWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;

public class ConfigGenerate
extends SessionBase
implements OutputCommand {
    private static CommandHelp sHelp = new ConfigGenerateHelp();
    private Closer mCloser = new Closer();
    private Host mHost;
    private Component mComponent;
    private ReaderWrapper mSrcStream;
    private ComponentVariableSettings mVarSettings;
    private OutputStream mOutputStream;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$config$commands$ConfigGenerate;

    public void setOutputStream(OutputStream stream) {
        this.mOutputStream = stream;
    }

    public OutputStream getOutputStream() {
        return this.mOutputStream;
    }

    public void setHost(Host host) {
        this.mHost = host;
    }

    public Host getHost() {
        return this.mHost;
    }

    public void setComponent(Component component) {
        this.mComponent = component;
    }

    public Component getComponent() {
        return this.mComponent;
    }

    public void setVarSettings(ComponentVariableSettings varsettings) {
        this.mVarSettings = varsettings;
    }

    public ComponentVariableSettings getVarSettings() {
        return this.mVarSettings;
    }

    public void setInputStream(ReaderWrapper src) {
        this.mSrcStream = src;
        this.mCloser.register(this.mSrcStream);
    }

    public ReaderWrapper getInputStream() {
        return this.mSrcStream;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        if (this.getOutputStream() == null) {
            this.setOutputStream(System.out);
        }
        RemoteConfigGenManager cgm = new RemoteConfigGenManager(Context.getVariableSettingsManager());
        SessionManager sm = Context.getSessionManager();
        Reader reader = this.getInputStream().getReader();
        UnicodeOutputStreamWriter uniWriter = new UnicodeOutputStreamWriter(this.getOutputStream(), reader);
        PrintWriter writer = new PrintWriter(uniWriter);
        ConfigGenerator generator = cgm.getConfigGenerator().newSessionScope(sm, false).newTargetScope(new TargetedConfigContext(this.getHost()), new PersistentInstallDBContext()).newComponentManager(this.getComponent(), this.getVarSettings()).newCallerScope(new Caller(null, this.getComponent()));
        generator.generate(this.getInputStream().getReader(), (Writer)writer);
        writer.flush();
    }

    public void cleanup() {
        super.cleanup();
        this.mCloser.closeAll();
    }

    protected static class ConfigGenerateHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cfg.gen.";
        private static final String MSG_COMMAND_DESC = "KEY:ui.cfg.gen.COMMAND_DESC";
        private static final String MSG_SRC_DESC = "KEY:ui.cfg.gen.SOURCE_DESC";
        private static final String MSG_HOST_DESC = "KEY:ui.cfg.gen.HOST_DESC";
        private static final String MSG_COMP_DESC = "KEY:ui.cfg.gen.COMP_DESC";
        private static final String MSG_VARSETTINGS_DESC = "KEY:ui.cfg.gen.VARSETTINGS_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("inputStream", MSG_SRC_DESC, "path"));
            map.addElement(new CommandHelpBase.RequiredArgInfo("host", MSG_HOST_DESC));
            map.addElement(new CommandHelpBase.RequiredArgInfo("component", MSG_COMP_DESC, "comp"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("varSettings", MSG_VARSETTINGS_DESC, "vs"));
            return map;
        }

        ConfigGenerateHelp() {
            super(class$com$raplix$rolloutexpress$ui$config$commands$ConfigGenerate == null ? (class$com$raplix$rolloutexpress$ui$config$commands$ConfigGenerate = ConfigGenerate.class$("com.raplix.rolloutexpress.ui.config.commands.ConfigGenerate")) : class$com$raplix$rolloutexpress$ui$config$commands$ConfigGenerate, MSG_COMMAND_DESC);
        }
    }
}

