/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.formatters;

import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.ConverterNotFoundException;
import com.raplix.rolloutexpress.ui.Formatter;
import com.raplix.rolloutexpress.ui.componentdb.formatters.ComponentDBUtil;
import com.raplix.rolloutexpress.ui.componentdb.formatters.PackageInfo;
import java.io.OutputStream;
import java.io.PrintWriter;

public class DefaultsAndOverridesFormatter
implements Formatter {
    private static final String MSG_NO_RESULT = "ui.cdb.format.NO_RESULT";

    private Object convert(Object src, Class dstClass) throws Exception {
        try {
            return Context.getConverterHandler().convert(src, dstClass);
        }
        catch (ConverterNotFoundException ex) {
            return null;
        }
    }

    private void write(Object src, PrintWriter pw) throws Exception {
        if (src == null) {
            pw.println(Context.getMessageText(MSG_NO_RESULT));
            return;
        }
        Object result = this.convert(src, ComponentVariableSettings.class);
        if (result != null) {
            ComponentDBUtil.defaultsAndOverridesWrite(pw, (ComponentVariableSettings)result, "");
            return;
        }
        PackageInfo.throwCannotWrite(src);
    }

    public void write(Object src, OutputStream out) throws Exception {
        PrintWriter pw = new PrintWriter(out);
        this.write(src, pw);
        pw.flush();
    }
}

