/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.formatters;

import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.CliRsrcData;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDescriptor;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceSelectorList;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.ui.Context;
import com.raplix.rolloutexpress.ui.hostdbx.formatters.HostUtil;
import com.raplix.rolloutexpress.ui.plandb.formatters.PlanDBUtil;
import com.raplix.rolloutexpress.ui.plugindb.formatters.PluginUtil;
import com.raplix.rolloutexpress.ui.userdb.formatters.UserUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.categories.CategoriesBean;
import com.raplix.rolloutexpress.ui.web.compx.ComponentDetailsBean;
import com.raplix.rolloutexpress.ui.web.resources.ResourceDetailsBean;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.string.StringUtil;
import com.raplix.util.table.Column;
import com.raplix.util.table.Table;
import java.io.PrintWriter;
import java.util.Date;

public final class ComponentDBUtil {
    private static final String COMP_FORMAT_PREFIX = "ui.cdb.format.c.";
    private static final String CONS_VIRTUAL_HOST = "ui.cdb.format.c.VIRTUAL_HOST";
    private static final String CONS_PHYSICAL_HOST = "ui.cdb.format.c.PHYSICAL_HOST";
    private static final String COMP_ID_HEADER = "ui.cdb.format.c.ID_HEADER";
    private static final String COMP_NAME_HEADER = "ui.cdb.format.c.NAME_HEADER";
    private static final String COMP_TYPE_HEADER = "ui.cdb.format.c.TYPE_HEADER";
    private static final String COMP_DESCRIPTION_HEADER = "ui.cdb.format.c.DESCRIPTION_HEADER";
    private static final String COMP_FROM_PLUGIN_HEADER = "ui.cdb.format.c.FROM_PLUGIN_HEADER";
    private static final String COMP_LABEL_HEADER = "ui.cdb.format.c.LABEL_HEADER";
    private static final String COMP_VERSION_HEADER = "ui.cdb.format.c.VERSION_HEADER";
    private static final String COMP_CHECKIN_DATE_HEADER = "ui.cdb.format.c.CHECKIN_DATE_HEADER";
    private static final String COMP_CHECKIN_USER_HEADER = "ui.cdb.format.c.CHECKIN_USER_HEADER";
    private static final String COMP_RESOURCES_HEADER = "ui.cdb.format.c.RESOURCES_HEADER";
    private static final String COMP_IS_HIDDEN_HEADER = "ui.cdb.format.c.IS_HIDDEN_HEADER";
    private static final String COMP_PLATFORM_HEADER = "ui.cdb.format.c.PLATFORM_HEADER";
    private static final String COMP_PROCEDURES_HEADER = "ui.cdb.format.c.PROCEDURES_HEADER";
    private static final String COMP_TARGET_REF_HEADER = "ui.cdb.format.c.TARGET_REF_HEADER";
    private static final String COMP_CATEGORY_HEADER = "ui.cdb.format.c.CATEGORY_HEADER";
    private static final String COMP_SOURCE_HEADER = "ui.cdb.format.c.COMP_SOURCE_HEADER";
    private static final String UNTYPED_COMPONENT_TYPE_LABEL = "ui.cdb.format.c.UNTYPED_COMPONENT_TYPE_LABEL";
    private static final String ANY_COMPONENT_TYPE_LABEL = "ui.cdb.format.c.ANY_COMPONENT_TYPE_LABEL";
    private static final String ABSTRACT_COMPONENT_LABEL = "ui.cdb.format.c.ABSTRACT_COMPONENT_LABEL";
    private static final String RSRCINFO_FORMAT_PREFIX = "ui.cdb.format.ri.";
    private static final String ABSTRACT_RESOURCE_LABEL = "ui.cdb.format.ri.ABSTRACT_RESOURCE_LABEL";
    private static final String NON_POSIX_RESOURCE_LABEL = "ui.cdb.format.ri.NON_POSIX_RESOURCE_LABEL";
    private static final String RESOURCE_ID_HEADER = "ui.cdb.format.ri.RESOURCE_ID_HEADER";
    private static final String RESOURCE_NAME_HEADER = "ui.cdb.format.ri.RESOURCE_NAME_HEADER";
    private static final String RESOURCE_TIMESTAMP_HEADER = "ui.cdb.format.ri.RESOURCE_TIMESTAMP_HEADER";
    private static final String RESOURCE_TOTAL_SIZE_HEADER = "ui.cdb.format.ri.RESOURCE_TOTAL_SIZE_HEADER";
    private static final String RESOURCE_USER_HEADER = "ui.cdb.format.ri.RESOURCE_USER_HEADER";
    private static final String RESOURCE_GROUP_HEADER = "ui.cdb.format.ri.RESOURCE_GROUP_HEADER";
    private static final String RESOURCE_PERMISSIONS_HEADER = "ui.cdb.format.ri.RESOURCE_PERMISSIONS_HEADER";
    private static final String RESOURCE_OPTIONS_HEADER = "ui.cdb.format.ri.RESOURCE_OPTIONS_HEADER";
    private static final String RESDEF_FORMAT_PREFIX = "ui.cdb.format.rd.";
    private static final String RESDEF_RESID_HEADER = "ui.cdb.format.rd.RESID_HEADER";
    private static final String RESDEF_NAME_HEADER = "ui.cdb.format.rd.NAME_HEADER";
    private static final String RESDEF_TYPE_HEADER = "ui.cdb.format.rd.TYPE_HEADER";
    private static final String RESDEF_VERSION_HEADER = "ui.cdb.format.rd.VERSION_HEADER";
    private static final String RESDEF_READONLY_HEADER = "ui.cdb.format.rd.READONLY_HEADER";
    private static final String VARDECL_FORMAT_PREFIX = "ui.cdb.format.vd.";
    private static final String COMP_VARIABLES_HEADER = "ui.cdb.format.vd.COMP_VARIABLES_HEADER";
    private static final String COMP_VARIABLE_NAME_HEADER = "ui.cdb.format.vd.COMP_VARIABLE_NAME_HEADER";
    private static final String COMP_VARIABLE_PROMPT_HEADER = "ui.cdb.format.vd.COMP_VARIABLE_PROMPT_HEADER";
    private static final String COMP_VARIABLE_VALUE_HEADER = "ui.cdb.format.vd.COMP_VARIABLE_VALUE_HEADER";
    private static final String COMP_VARIABLE_READONLY_HEADER = "ui.cdb.format.vd.READONLY_HEADER";
    private static final String COMPONENT_PROCEDURE_PREFIX = "ui.cdb.format.cp.";
    private static final String PROCEDURE_NAME_HEADER = "ui.cdb.format.cp.NAME_HEADER";
    private static final String PROCEDURE_TYPE_HEADER = "ui.cdb.format.cp.TYPE_HEADER";
    private static final String INSTCOMP_FORMAT_PREFIX = "ui.cdb.format.ic.";
    private static final String INSTCOMP_ID_HEADER = "ui.cdb.format.ic.ID_HEADER";
    private static final String INSTCOMP_COMP_HEADER = "ui.cdb.format.ic.COMP_HEADER";
    private static final String INSTCOMP_HOST_HEADER = "ui.cdb.format.ic.HOST_HEADER";
    private static final String INSTCOMP_TASKID_HEADER = "ui.cdb.format.ic.TASKID_HEADER";
    private static final String INSTCOMP_PLAN_HEADER = "ui.cdb.format.ic.PLAN_HEADER";
    private static final String INSTCOMP_USER_HEADER = "ui.cdb.format.ic.USER_HEADER";
    private static final String INSTCOMP_DATE_HEADER = "ui.cdb.format.ic.DATE_HEADER";
    private static final String INSTCOMP_INDEX_HEADER = "ui.cdb.format.ic.INDEX_HEADER";
    private static final String INSTCOMP_INSTALLPATH_HEADER = "ui.cdb.format.ic.INSTALLPATH_HEADER";
    private static final String INSTCOMP_CREATED_HOST_HEADER = "ui.cdb.format.ic.INSTALLHOST_HEADER";
    private static final String INSTCOMP_VARSETTINGS_HEADER = "ui.cdb.format.ic.VARSETTINGS_HEADER";
    private static final String INSTCOMPDEP_FORMAT_PREFIX = "ui.cdb.format.ic.dep.";
    private static final String INSTCOMPDEP_NAME_HEADER = "ui.cdb.format.ic.dep.NAME_HEADER";
    private static final String INSTCOMPDEP_DEPENDANT_INSTCOMPID_HEADER = "ui.cdb.format.ic.dep.DEPENDANT_INSTCOMPID_HEADER";
    private static final String INSTCOMPDEP_DEPENDEE_INSTCOMPID_HEADER = "ui.cdb.format.ic.dep.DEPENDEE_INSTCOMPID_HEADER";
    private static final String INSTCOMPDEP_DEPENDEEINDEX_HEADER = "ui.cdb.format.ic.dep.DEPENDEEINDEX_HEADER";
    private static final String INSTCOMPDEP_DEPENDANTINDEX_HEADER = "ui.cdb.format.ic.dep.DEPENDANTINDEX_HEADER";
    private static final String GENVARSETTINGS_FORMAT_PREFIX = "ui.cdb.format.ic.vs.";
    private static final String GENVARSETTINGS_ID_HEADER = "ui.cdb.format.ic.vs.ID_HEADER";
    private static final String GENVARSETTINGS_NAME_HEADER = "ui.cdb.format.ic.vs.NAME_HEADER";
    private static final String GENVARSETTINGS_VARTABLE_HEADER = "ui.cdb.format.ic.vs.VARTABLE_HEADER";
    private static final String GENVARSETTINGS_VARNAME_HEADER = "ui.cdb.format.ic.vs.VARNAME_HEADER";
    private static final String GENVARSETTINGS_VARNAME_PROMPT = "ui.cdb.format.ic.vs.VARNAME_PROMPT";
    private static final String GENVARSETTINGS_VARVALUE_HEADER = "ui.cdb.format.ic.vs.VARVALUE_HEADER";
    private static final String GENVARSETTINGS_COLUMN_ID = "ui.cdb.format.ic.vs.COLUMN_ID";
    private static final String GENVARSETTINGS_COLUMN_NAME = "ui.cdb.format.ic.vs.COLUMN_NAME";
    private static final String VARSETTINGS_FORMAT_PREFIX = "ui.cdb.format.vs.";
    private static final String VARSETTINGS_ID_HEADER = "ui.cdb.format.vs.ID_HEADER";
    private static final String VARSETTINGS_NAME_HEADER = "ui.cdb.format.vs.NAME_HEADER";
    private static final String VARSETTINGS_COMP_HEADER = "ui.cdb.format.vs.COMP_HEADER";
    private static final String VARSETTINGS_VARTABLE_HEADER = "ui.cdb.format.vs.VARTABLE_HEADER";
    private static final String VARSETTINGS_VARNAME_HEADER = "ui.cdb.format.vs.VARNAME_HEADER";
    private static final String VARSETTINGS_VARPROMPT_HEADER = "ui.cdb.format.vs.VARPROMPT_HEADER";
    private static final String VARSETTINGS_DEFAULT_HEADER = "ui.cdb.format.vs.DEFAULT_HEADER";
    private static final String VARSETTINGS_OVERRIDE_HEADER = "ui.cdb.format.vs.OVERRIDE_HEADER";
    private static final String VARSETTINGS_READONLY_HEADER = "ui.cdb.format.vs.READONLY_HEADER";
    private static final String VARSETTINGS_COLUMN_ID = "ui.cdb.format.vs.COLUMN_ID";
    private static final String VARSETTINGS_COLUMN_NAME = "ui.cdb.format.vs.COLUMN_NAME";
    private static final String COMPSEL_FORMAT_PREFIX = "ui.cdb.format.cs.";
    private static final String COMPSEL_COMPID_HEADER = "ui.cdb.format.cs.COMPID_HEADER";
    private static final String COMPSEL_COMPNAME_HEADER = "ui.cdb.format.cs.COMPNAME_HEADER";
    private static final String COMPSEL_COMPVERSION_HEADER = "ui.cdb.format.cs.COMPVERSION_HEADER";
    private static final String COMPSEL_VARSETTINGSNAME_HEADER = "ui.cdb.format.cs.VARSETTINGSNAME_HEADER";
    private static final String COMPSEL_NOVARSETTINGS_VALUE = "ui.cdb.format.cs.NOVARSETTINGS_VALUE";
    private static final String COMPSEL_DEFAULT_VALUE = "ui.cdb.format.cs.DEFAULT_VALUE";
    private static final String SSR_FORMAT_PREFIX = "ui.cdb.format.ssr.";
    private static final String SSR_ID_HEADER = "ui.cdb.format.ssr.ID_HEADER";
    private static final String SSR_NAME_HEADER = "ui.cdb.format.ssr.NAME_HEADER";
    private static final String SSR_DESCRIPTION_HEADER = "ui.cdb.format.ssr.DESCRIPTION_HEADER";
    private static final String SSR_FROM_PLUGIN_HEADER = "ui.cdb.format.ssr.FROM_PLUGIN_HEADER";
    private static final String SSR_INST_COMP_NAME_HEADER = "ui.cdb.format.ssr.INST_COMP_NAME_HEADER";
    private static final String SSR_INST_COMP_VERSION_HEADER = "ui.cdb.format.ssr.INST_COMP_VERSION_HEADER";
    private static final String SSR_INST_COMP_PATH_HEADER = "ui.cdb.format.ssr.INST_COMP_PATH_HEADER";
    private static final String CTR_FORMAT_PREFIX = "ui.cdb.format.ctr.";
    private static final String CTR_ID_HEADER = "ui.cdb.format.ctr.ID_HEADER";
    private static final String CTR_NAME_HEADER = "ui.cdb.format.ctr.NAME_HEADER";
    private static final String CTR_DESCRIPTION_HEADER = "ui.cdb.format.ctr.DESCRIPTION_HEADER";
    private static final String CTR_FROM_PLUGIN_HEADER = "ui.cdb.format.ctr.FROM_PLUGIN_HEADER";
    private static final String CTR_ORDER_HEADER = "ui.cdb.format.ctr.ORDER_HEADER";
    private static final String CTR_GROUP_HEADER = "ui.cdb.format.ctr.GROUP_HEADER";
    private static final String CTR_INDENT_LEVEL_HEADER = "ui.cdb.format.ctr.INDENT_LEVEL_HEADER";
    private static final String CTR_COMPONENT_HEADER = "ui.cdb.format.ctr.COMPONENT_HEADER";
    private static final String CTR_VERSION_HEADER = "ui.cdb.format.ctr.VERSION_HEADER";
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$componentdb$formatters$ComponentDBUtil;

    private ComponentDBUtil() {
    }

    public static void write(PrintWriter pw, SummaryComponent sc, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_ID_HEADER) + ": " + sc.getID());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_NAME_HEADER) + ": " + sc.getFullName());
        pw.print(prefix);
        String type = ComponentDBUtil.toText(COMP_TYPE_HEADER) + ": ";
        type = sc.getExtendsTypeName() == null ? type + ComponentDBUtil.toText(UNTYPED_COMPONENT_TYPE_LABEL) : type + sc.getExtendsTypeName();
        if (sc.getModifier().equals(Modifier.ABSTRACT)) {
            type = type + " (" + ComponentDBUtil.toText(ABSTRACT_COMPONENT_LABEL) + ")";
        }
        pw.println(type);
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_VERSION_HEADER) + ": " + ComponentDBUtil.getComponentVersion(sc));
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_PLATFORM_HEADER) + ": " + sc.getPlatform());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_CHECKIN_DATE_HEADER) + ": " + ComponentDBUtil.convert(sc.getTimeStamp(), String.class));
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_CHECKIN_USER_HEADER) + ":");
        UserUtil.write(pw, sc.getUserID(), prefix + " ");
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_LABEL_HEADER) + ": " + sc.getLabel());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_DESCRIPTION_HEADER) + ": " + sc.getDescription());
        pw.print(prefix);
        if (sc.getPluginID() != null) {
            pw.println(ComponentDBUtil.toText(COMP_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{sc.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_IS_HIDDEN_HEADER) + ": " + new Boolean(sc.getVisibility().equals(Visibility.HIDDEN)));
    }

    public static void write(PrintWriter pw, Component c, String prefix) throws Exception {
        SourceInfo si;
        ComponentDBUtil.write(pw, (SummaryComponent)c, prefix);
        CategoryIDSet catSet = c.getCategories();
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_CATEGORY_HEADER) + ": " + CategoriesBean.getCategoryNamesString(catSet));
        if (c.getTargetRef() != null) {
            pw.print(prefix);
            String tempN = c.getTargetRef().getHostName();
            String tempVirtualORPhysical = c.getTargetRef().isVirtual() ? ComponentDBUtil.toText(CONS_VIRTUAL_HOST) : ComponentDBUtil.toText(CONS_PHYSICAL_HOST);
            pw.println(ComponentDBUtil.toText(COMP_TARGET_REF_HEADER) + ": " + tempN + " (" + tempVirtualORPhysical + ")");
        }
        if ((si = c.getSourceInfo()) != null) {
            pw.print(prefix);
            pw.println(ComponentDBUtil.toText(COMP_SOURCE_HEADER) + ": " + ComponentDetailsBean.generateComponentSource(si));
        }
        pw.print(prefix);
        if (c.isSimpleComponent()) {
            pw.println(c.getExtendsTypeName() + ":");
            ComponentDBUtil.write(pw, c.getResource(), prefix + " ");
            pw.print(prefix);
            pw.println(ComponentDBUtil.toText(RESOURCE_OPTIONS_HEADER) + ":");
            if (si != null) {
                String[] optionsDescs = si.getVarDescriptions();
                for (int i = 0; i < optionsDescs.length; ++i) {
                    pw.print(prefix);
                    pw.println(" +" + optionsDescs[i]);
                }
            }
        } else {
            pw.println(ComponentDBUtil.toText(COMP_RESOURCES_HEADER) + ":");
            ComponentDescriptor cd = ComponentDescriptor.create(c.getID());
            ResourceSelectorList rsl = cd.getResourceSelectors();
            ComponentDBUtil.write(pw, rsl, prefix + " ");
        }
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_VARIABLES_HEADER) + ":");
        ComponentDBUtil.write(pw, c.getVarList(null), prefix + " ");
        ComponentDBUtil.printProcedures(pw, c, prefix);
    }

    private static void printProcedures(PrintWriter pw, Component c, String prefix) {
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(COMP_PROCEDURES_HEADER) + ":");
        Column[] columns = new Column[]{new Column(30, 0, ComponentDBUtil.toText(PROCEDURE_NAME_HEADER)), new Column(30, 0, ComponentDBUtil.toText(PROCEDURE_TYPE_HEADER))};
        NamedBlock[] il = c.getInstallList(CallSpec.PUBLIC);
        NamedBlock[] ul = c.getUninstallList(CallSpec.PUBLIC);
        NamedBlock[] cl = c.getControlList(CallSpec.PUBLIC);
        Table t = new Table(pw, columns, prefix + " ");
        ComponentDBUtil.printProcedure(t, NamedBlockType.INSTALL.toString(), il);
        ComponentDBUtil.printProcedure(t, NamedBlockType.UNINSTALL.toString(), ul);
        ComponentDBUtil.printProcedure(t, NamedBlockType.CONTROL.toString(), cl);
        t.endPrinting();
    }

    private static void write(PrintWriter pw, ResourceSelectorList rsl, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, ComponentDBUtil.toText(RESDEF_RESID_HEADER)), new Column(15, 0, ComponentDBUtil.toText(RESDEF_NAME_HEADER)), new Column(15, 0, ComponentDBUtil.toText(RESDEF_TYPE_HEADER)), new Column(7, 0, ComponentDBUtil.toText(RESDEF_VERSION_HEADER)), new Column(7, 0, ComponentDBUtil.toText(RESDEF_READONLY_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[5];
        for (int i = 0; i < rsl.size(); ++i) {
            ResourceSelector rs = rsl.getSelector(i);
            Component c = rs.getCurrent();
            if (c == null) {
                data[0] = "";
                data[1] = "";
                data[2] = rs.getType().equals(ComponentType.ROOT) ? ComponentDBUtil.toText(ANY_COMPONENT_TYPE_LABEL) : rs.getType().getTypeName();
                data[3] = "";
            } else {
                data[0] = c.getID().toString();
                data[1] = c.getFullName();
                data[2] = c.getExtendsTypeName() == null ? ComponentDBUtil.toText(UNTYPED_COMPONENT_TYPE_LABEL) : c.getExtendsTypeName();
                data[3] = c.getVersionNumber().getAsString();
            }
            data[4] = rs.isReadOnly() ? "true" : "false";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, RsrcInfo ri, String prefix) throws Exception {
        String resourceID = ComponentDBUtil.toText(ABSTRACT_RESOURCE_LABEL);
        String fileSystemSize = ComponentDBUtil.toText(ABSTRACT_RESOURCE_LABEL);
        String fileSystemName = ComponentDBUtil.toText(ABSTRACT_RESOURCE_LABEL);
        String timeStamp = ComponentDBUtil.toText(ABSTRACT_RESOURCE_LABEL);
        String userName = ComponentDBUtil.toText(ABSTRACT_RESOURCE_LABEL);
        String groupName = ComponentDBUtil.toText(ABSTRACT_RESOURCE_LABEL);
        String permissions = ComponentDBUtil.toText(ABSTRACT_RESOURCE_LABEL);
        if (ri != null) {
            CliRsrcData resourceMgr = Context.getCliRsrcData();
            ResourceEntry entry = resourceMgr.getTopResourceEntry(ri.getResourceID());
            resourceID = ri.getResourceID().toString();
            fileSystemSize = ResourceDetailsBean.convertFileSize(entry.getSize());
            fileSystemName = ResourceDetailsBean.extractName(ri.getName());
            timeStamp = Util.formatDate(new Date(entry.getTime()));
            NodePerms nodePerms = entry.getPerms();
            if (nodePerms instanceof PosixNodePerms) {
                PosixNodePerms perms = (PosixNodePerms)nodePerms;
                userName = perms.getOwnerName();
                groupName = perms.getGroupName();
                permissions = new Mask((int)perms.getPermBits()).toString();
                if (entry.getType() == SubnodeType.DIRECTORY) {
                    permissions = "d" + permissions;
                }
            } else {
                userName = ComponentDBUtil.toText(NON_POSIX_RESOURCE_LABEL);
                groupName = ComponentDBUtil.toText(NON_POSIX_RESOURCE_LABEL);
                permissions = ComponentDBUtil.toText(NON_POSIX_RESOURCE_LABEL);
            }
        }
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(RESOURCE_ID_HEADER) + ": " + resourceID);
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(RESOURCE_NAME_HEADER) + ": " + fileSystemName);
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(RESOURCE_TIMESTAMP_HEADER) + ": " + timeStamp);
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(RESOURCE_TOTAL_SIZE_HEADER) + ": " + fileSystemSize);
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(RESOURCE_USER_HEADER) + ": " + userName);
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(RESOURCE_GROUP_HEADER) + ": " + groupName);
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(RESOURCE_PERMISSIONS_HEADER) + ": " + permissions);
    }

    public static void write(PrintWriter pw, VarDecl[] vda, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(25, 0, ComponentDBUtil.toText(COMP_VARIABLE_NAME_HEADER)), new Column(25, 0, ComponentDBUtil.toText(COMP_VARIABLE_PROMPT_HEADER)), new Column(25, 0, ComponentDBUtil.toText(COMP_VARIABLE_VALUE_HEADER)), new Column(10, 0, ComponentDBUtil.toText(COMP_VARIABLE_READONLY_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[4];
        for (int i = 0; i < vda.length; ++i) {
            data[0] = vda[i].getName();
            data[1] = StringUtil.normalizeEmpty(vda[i].getPrompt());
            data[2] = vda[i].getDefaultValue();
            data[3] = vda[i].getModifier().equals(Modifier.FINAL) ? "true" : "false";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    private static void printProcedure(Table t, String procedureType, NamedBlock[] procedures) {
        String[] data = new String[2];
        for (int i = 0; i < procedures.length; ++i) {
            data[0] = procedures[i].getName();
            data[1] = procedureType;
            t.printRow(CollectionUtil.getEnumeration(data));
        }
    }

    private static String getComponentVersion(SummaryComponent c) {
        return c.getVersionNumber().getAsString();
    }

    public static void write(PrintWriter pw, SummaryComponent[] a, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, ComponentDBUtil.toText(COMP_ID_HEADER)), new Column(15, 0, ComponentDBUtil.toText(COMP_NAME_HEADER)), new Column(5, 0, ComponentDBUtil.toText(COMP_VERSION_HEADER)), new Column(10, 0, ComponentDBUtil.toText(COMP_LABEL_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[4];
        for (int i = 0; i < a.length; ++i) {
            data[0] = a[i].getID().toString();
            data[1] = a[i].getFullName();
            data[2] = ComponentDBUtil.getComponentVersion(a[i]);
            data[3] = a[i].getLabel();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, InstalledComponentBean c, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_ID_HEADER) + ": " + c.getInstalledComponentID().toString());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_COMP_HEADER) + ":");
        ComponentDBUtil.write(pw, new SummaryComponent[]{c.getComponent()}, prefix + " ");
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_HOST_HEADER) + ":");
        HostUtil.write(pw, c.getTarget(), prefix + " ");
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_TASKID_HEADER) + ": " + c.getTaskID());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_PLAN_HEADER) + ":");
        PlanDBUtil.write(pw, new SummaryExecutionPlan[]{c.getExecutionPlan()}, prefix + " ");
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_USER_HEADER) + ":");
        UserUtil.write(pw, c.getUserID(), prefix + " ");
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_DATE_HEADER) + ": " + ComponentDBUtil.convert(c.getDate(), String.class));
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_INSTALLPATH_HEADER) + ": " + c.getComponentInstallPath());
        SummaryHost targetHost = null;
        try {
            targetHost = SingleHostQuery.byInstalledComponentID(c.getInstalledComponentID()).selectSummaryView();
            pw.print(prefix);
            pw.println(ComponentDBUtil.toText(INSTCOMP_CREATED_HOST_HEADER) + ": ");
            HostUtil.write(pw, new SummaryHost[]{targetHost}, prefix + " ");
        }
        catch (NoResultsFoundException e) {
            // empty catch block
        }
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(INSTCOMP_VARSETTINGS_HEADER) + ":");
        ComponentDBUtil.write(pw, new GeneratedVariableSettings[]{c.getGeneratedVariableSettings()}, prefix + " ");
    }

    public static void write(PrintWriter pw, InstalledComponentBean[] a, String prefix) throws Exception {
        for (int i = 0; i < a.length; ++i) {
            pw.print(prefix);
            pw.println(ComponentDBUtil.toText(INSTCOMP_INDEX_HEADER) + ": " + (i + 1));
            ComponentDBUtil.write(pw, a[i], prefix + " ");
        }
    }

    public static void writeDependency(PrintWriter pw, Dependency[] d, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(25, 0, ComponentDBUtil.toText(INSTCOMPDEP_NAME_HEADER)), new Column(45, 0, ComponentDBUtil.toText(INSTCOMPDEP_DEPENDEE_INSTCOMPID_HEADER)), new Column(45, 0, ComponentDBUtil.toText(INSTCOMPDEP_DEPENDANT_INSTCOMPID_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[3];
        for (int i = 0; i < d.length; ++i) {
            data[0] = d[i].getName();
            data[1] = d[i].getDependeeInstalledComponentID().toString();
            data[2] = d[i].getDependantInstalledComponentID().toString();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void deepWriteDependency(PrintWriter pw, Dependency[] d, String prefix, boolean isDependee) throws Exception {
        for (int i = 0; i < d.length; ++i) {
            pw.print(prefix);
            if (isDependee) {
                pw.println(ComponentDBUtil.toText(INSTCOMPDEP_DEPENDEEINDEX_HEADER) + ": " + (i + 1));
            } else {
                pw.println(ComponentDBUtil.toText(INSTCOMPDEP_DEPENDANTINDEX_HEADER) + ": " + (i + 1));
            }
            pw.print(prefix + " ");
            pw.println(ComponentDBUtil.toText(INSTCOMPDEP_NAME_HEADER) + ": " + d[i].getName());
            InstalledComponentIDSet idSet = new InstalledComponentIDSet();
            pw.print(prefix + " ");
            if (isDependee) {
                pw.println(ComponentDBUtil.toText(INSTCOMPDEP_DEPENDANT_INSTCOMPID_HEADER) + ": " + d[i].getDependantInstalledComponentID());
                idSet.add(d[i].getDependeeInstalledComponentID());
            } else {
                pw.println(ComponentDBUtil.toText(INSTCOMPDEP_DEPENDEE_INSTCOMPID_HEADER) + ": " + d[i].getDependeeInstalledComponentID());
                idSet.add(d[i].getDependantInstalledComponentID());
            }
            InstalledComponentBean[] b = (InstalledComponentBean[])idSet.resolveIDs().selectObjects();
            if (b == null || b.length != 1) {
                Logger.warn("Cannot load InstalledComponentBean for " + idSet, class$com$raplix$rolloutexpress$ui$componentdb$formatters$ComponentDBUtil == null ? ComponentDBUtil.class$("com.raplix.rolloutexpress.ui.componentdb.formatters.ComponentDBUtil") : class$com$raplix$rolloutexpress$ui$componentdb$formatters$ComponentDBUtil);
                continue;
            }
            ComponentDBUtil.write(pw, b[0], prefix + " ");
        }
    }

    public static void write(PrintWriter pw, ComponentVariableSettings c, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(VARSETTINGS_ID_HEADER) + ": " + c.getID());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(VARSETTINGS_NAME_HEADER) + ": " + c.getName());
        pw.print(prefix);
        Component sc = c.getComponent().getID().getByIDQuery().select();
        pw.println(ComponentDBUtil.toText(VARSETTINGS_COMP_HEADER) + ":");
        SummaryComponent[] comp = new SummaryComponent[]{sc};
        ComponentDBUtil.write(pw, comp, prefix + " ");
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(VARSETTINGS_VARTABLE_HEADER) + ":");
        Column[] columns = new Column[]{new Column(24, 0, ComponentDBUtil.toText(VARSETTINGS_VARNAME_HEADER)), new Column(18, 0, ComponentDBUtil.toText(VARSETTINGS_VARPROMPT_HEADER)), new Column(18, 0, ComponentDBUtil.toText(VARSETTINGS_DEFAULT_HEADER)), new Column(18, 0, ComponentDBUtil.toText(VARSETTINGS_OVERRIDE_HEADER)), new Column(10, 0, ComponentDBUtil.toText(VARSETTINGS_READONLY_HEADER))};
        Table t = new Table(pw, columns, prefix + " ");
        String[] varnames = c.getVarNames();
        String[] data = new String[5];
        for (int i = 0; i < varnames.length; ++i) {
            String varname = varnames[i];
            String varprompt = StringUtil.normalizeEmpty(sc.resolveVar(varname, CallSpec.PUBLIC).getPrompt());
            String vardef = sc.resolveVar(varname, CallSpec.PUBLIC).getDefaultValue();
            String varoverride = c.getOverrideVarValue(varname);
            data[0] = varname;
            data[1] = varprompt;
            data[2] = vardef;
            data[3] = varoverride != null ? varoverride : vardef + "*";
            data[4] = c.isReadOnlyVar(varname) ? "true" : "false";
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void defaultsAndOverridesWrite(PrintWriter pw, ComponentVariableSettings c, String prefix) throws Exception {
        String[] varNames = c.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            pw.print(varNames[i]);
            pw.print("=");
            pw.print(c.getVarValue(varNames[i]));
            pw.print(";");
        }
        pw.println();
    }

    public static void overridesOnlyWrite(PrintWriter pw, ComponentVariableSettings c, String prefix) throws Exception {
        String[] varNames = c.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            String varOverride = c.getOverrideVarValue(varNames[i]);
            if (varOverride == null) continue;
            pw.print(varNames[i]);
            pw.print("=");
            pw.print(varOverride);
            pw.print(";");
        }
        pw.println();
    }

    public static void write(PrintWriter pw, ComponentVariableSettings[] c, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, ComponentDBUtil.toText(VARSETTINGS_COLUMN_ID)), new Column(20, 0, ComponentDBUtil.toText(VARSETTINGS_COLUMN_NAME))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < c.length; ++i) {
            data[0] = c[i].getID().toString();
            data[1] = c[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, ComponentSelector[] a, String prefix) throws Exception {
        SummaryComponent[] components = new SummaryComponent[a.length];
        String[] varsettings = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getCurrent() != null) {
                components[i] = a[i].getCurrent().getComponent();
                if (a[i].getCurrent().getCurrent() != null) {
                    varsettings[i] = a[i].getCurrent().getCurrent().getName();
                    continue;
                }
                varsettings[i] = null;
                continue;
            }
            components[i] = null;
            varsettings[i] = null;
        }
        ComponentDBUtil.write(pw, components, varsettings, prefix);
    }

    public static void write(PrintWriter pw, SummaryComponent[] c, String[] v, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, ComponentDBUtil.toText(COMPSEL_COMPID_HEADER)), new Column(20, 0, ComponentDBUtil.toText(COMPSEL_COMPNAME_HEADER)), new Column(5, 0, ComponentDBUtil.toText(COMPSEL_COMPVERSION_HEADER)), new Column(22, 0, ComponentDBUtil.toText(COMPSEL_VARSETTINGSNAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[4];
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == null) {
                data[0] = ComponentDBUtil.toText(COMPSEL_NOVARSETTINGS_VALUE);
                data[1] = ComponentDBUtil.toText(COMPSEL_NOVARSETTINGS_VALUE);
                data[2] = ComponentDBUtil.toText(COMPSEL_NOVARSETTINGS_VALUE);
                data[3] = ComponentDBUtil.toText(COMPSEL_NOVARSETTINGS_VALUE);
            } else {
                SummaryComponent comp = c[i];
                data[0] = comp.getID().toString();
                data[1] = comp.getFullName();
                data[2] = ComponentDBUtil.getComponentVersion(comp);
                data[3] = v[i] == null ? ComponentDBUtil.toText(COMPSEL_DEFAULT_VALUE) : v[i];
            }
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, SystemServiceRef ssr, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(SSR_ID_HEADER) + ": " + ssr.getID());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(SSR_NAME_HEADER) + ": " + ssr.getName());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(SSR_DESCRIPTION_HEADER) + ": " + ssr.getDescription());
        pw.print(prefix);
        if (ssr.getPluginID() != null) {
            pw.println(ComponentDBUtil.toText(SSR_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{ssr.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        InstalledComponentRef icr = ssr.getInstalledComponentRef();
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(SSR_INST_COMP_NAME_HEADER) + ": " + icr.getComponentFullName());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(SSR_INST_COMP_VERSION_HEADER) + ": " + icr.getComponentVersion());
        pw.print(prefix);
        String path = icr.getInstallPath();
        if (path == null) {
            path = "";
        }
        pw.println(ComponentDBUtil.toText(SSR_INST_COMP_PATH_HEADER) + ": " + path);
    }

    public static void write(PrintWriter pw, SystemServiceRef[] a, String prefix) {
        Column[] columns = new Column[]{new Column(45, 0, ComponentDBUtil.toText(SSR_ID_HEADER)), new Column(30, 0, ComponentDBUtil.toText(SSR_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < a.length; ++i) {
            data[0] = a[i].getID().toString();
            data[1] = a[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, ComponentTypeRef ctr, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_ID_HEADER) + ": " + ctr.getID());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_NAME_HEADER) + ": " + ctr.getName());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_DESCRIPTION_HEADER) + ": " + ctr.getDescription());
        pw.print(prefix);
        if (ctr.getPluginID() != null) {
            pw.println(ComponentDBUtil.toText(CTR_FROM_PLUGIN_HEADER) + ":");
            PluginUtil.detailedWrite(pw, new SummaryPlugin[]{ctr.getPluginID().getByIDQuery().selectSummaryView()}, prefix + " ");
        }
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_ORDER_HEADER) + ": " + ctr.getOrder());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_GROUP_HEADER) + ": " + ctr.getGroup());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_INDENT_LEVEL_HEADER) + ": " + ctr.getIndentLevel());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_COMPONENT_HEADER) + ": " + ctr.getComponentRef().getComponentFullName());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(CTR_VERSION_HEADER) + ": " + ctr.getComponentRef().getComponentVersion());
    }

    public static void write(PrintWriter pw, ComponentTypeRef[] a, String prefix) {
        Column[] columns = new Column[]{new Column(45, 0, ComponentDBUtil.toText(CTR_ID_HEADER)), new Column(30, 0, ComponentDBUtil.toText(CTR_NAME_HEADER))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < a.length; ++i) {
            data[0] = a[i].getID().toString();
            data[1] = a[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, GeneratedVariableSettings g, String prefix) throws Exception {
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(GENVARSETTINGS_ID_HEADER) + ": " + g.getID());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(GENVARSETTINGS_NAME_HEADER) + ": " + g.getName());
        pw.print(prefix);
        pw.println(ComponentDBUtil.toText(GENVARSETTINGS_VARTABLE_HEADER) + ":");
        Column[] columns = new Column[]{new Column(25, 0, ComponentDBUtil.toText(GENVARSETTINGS_VARNAME_HEADER)), new Column(25, 0, ComponentDBUtil.toText(GENVARSETTINGS_VARVALUE_HEADER))};
        Table t = new Table(pw, columns, prefix + " ");
        String[] varnames = g.getVarNames();
        String[] data = new String[2];
        for (int i = 0; i < varnames.length; ++i) {
            data[0] = varnames[i];
            data[1] = g.getVarValue(varnames[i]);
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    public static void write(PrintWriter pw, GeneratedVariableSettings[] g, String prefix) throws Exception {
        Column[] columns = new Column[]{new Column(45, 0, ComponentDBUtil.toText(GENVARSETTINGS_COLUMN_ID)), new Column(20, 0, ComponentDBUtil.toText(GENVARSETTINGS_COLUMN_NAME))};
        Table t = new Table(pw, columns, prefix);
        String[] data = new String[2];
        for (int i = 0; i < g.length; ++i) {
            data[0] = g[i].getID().toString();
            data[1] = g[i].getName();
            t.printRow(CollectionUtil.getEnumeration(data));
        }
        t.endPrinting();
    }

    private static Object convert(Object inObj, Class cls) throws Exception {
        return Context.getConverterHandler().convert(inObj, cls);
    }

    protected static String toText(String messageKey) {
        return Context.getMessageText(messageKey);
    }
}

