/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.componentdb.converters.InstalledResourceRefBase;
import java.util.StringTokenizer;

public class String2InstalledComponentRef
extends InstalledResourceRefBase
implements Converter {
    public static InstalledComponentRef convert(String src) throws PersistenceManagerException, RPCException {
        StringTokenizer t = new StringTokenizer(src, ":");
        String name = null;
        FolderID folderID = null;
        String version = null;
        String installPath = null;
        if (t.hasMoreTokens()) {
            String fullName = t.nextToken();
            int sepNdx = fullName.lastIndexOf("/");
            if (sepNdx == -1) {
                folderID = FolderID.ROOT_FOLDER_ID;
                name = fullName;
            } else {
                folderID = SingleFolderQuery.byPath(fullName.substring(0, sepNdx + 1)).selectSummaryView().getID();
                name = fullName.substring(sepNdx + 1);
            }
        }
        if (t.hasMoreTokens()) {
            version = t.nextToken();
        }
        if (t.hasMoreTokens()) {
            installPath = t.nextToken();
        }
        return new InstalledComponentRef(folderID, name, version, Comparator.EQUAL, false, installPath, false);
    }
}

