/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.componentdb.converters.ComponentVariableSettingsID2ComponentVariableSettings;
import com.raplix.rolloutexpress.ui.componentdb.converters.PackageInfo;
import com.raplix.rolloutexpress.ui.componentdb.converters.String2ComponentVariableSettingsID;
import com.raplix.rolloutexpress.ui.converters.Prefixes;
import java.util.StringTokenizer;

public class String2ComponentVariableSettings
implements Converter,
Prefixes {
    public static final char TOKEN_SEPARATOR = ':';

    public static ComponentVariableSettings convert(String src) throws PersistenceManagerException, RPCException {
        if ((src = src.trim()).startsWith("NM:")) {
            src = src.substring("NM:".length());
            return String2ComponentVariableSettings.convertByName(src);
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return String2ComponentVariableSettings.convertByID(src);
    }

    public static ComponentVariableSettings convertByID(String ID2) throws RPCException, PersistenceManagerException {
        ComponentVariableSettingsID id = String2ComponentVariableSettingsID.convertByID(ID2);
        return ComponentVariableSettingsID2ComponentVariableSettings.convert(id);
    }

    public static ComponentVariableSettings convertByName(String name) throws PersistenceManagerException, RPCException {
        FolderID folderID;
        String varSettingsName;
        String version;
        StringTokenizer tokens = new StringTokenizer(name, String.valueOf(':'));
        int numtokens = tokens.countTokens();
        if (numtokens <= 1 || numtokens > 3) {
            PackageInfo.throwIllegalVarSettingsName(name);
        }
        String compName = tokens.nextToken();
        if (numtokens == 2) {
            version = null;
            varSettingsName = tokens.nextToken();
        } else {
            version = tokens.nextToken();
            varSettingsName = tokens.nextToken();
        }
        int sepNdx = compName.lastIndexOf("/");
        if (sepNdx == -1) {
            folderID = null;
        } else {
            folderID = SingleFolderQuery.byPath(compName.substring(0, sepNdx + 1)).selectSummaryView().getID();
            compName = compName.substring(sepNdx + 1);
        }
        SummaryComponent comp = SingleComponentQuery.byName(folderID, compName, version).selectSummaryView();
        return comp.getID().getVariableSettingsQuery(varSettingsName).select();
    }
}

