/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.converters;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.Converter;
import com.raplix.rolloutexpress.ui.componentdb.converters.ComponentID2Component;
import com.raplix.rolloutexpress.ui.componentdb.converters.String2ComponentID;
import com.raplix.rolloutexpress.ui.converters.Prefixes;

public class String2Component
implements Converter,
Prefixes {
    public static final char VERSION_SEPARATOR = ':';

    public static Component convert(String src) throws PersistenceManagerException, RPCException {
        if ((src = src.trim()).startsWith("NM:")) {
            src = src.substring("NM:".length());
            return String2Component.convertByName(src);
        }
        if (src.startsWith("ID:")) {
            src = src.substring("ID:".length());
        }
        return String2Component.convertByID(src);
    }

    public static Component convertByID(String ID2) throws PersistenceManagerException, RPCException {
        ComponentID componentID = String2ComponentID.convertByID(ID2);
        return ComponentID2Component.convert(componentID);
    }

    public static Component convertByName(String componentName) throws PersistenceManagerException, RPCException {
        FolderID folderID;
        String name;
        String version;
        int sepNdx = componentName.indexOf(58);
        if (sepNdx == -1) {
            version = null;
            name = componentName;
        } else {
            version = componentName.substring(sepNdx + 1);
            name = componentName.substring(0, sepNdx);
        }
        sepNdx = name.lastIndexOf("/");
        if (sepNdx == -1) {
            folderID = null;
        } else {
            folderID = SingleFolderQuery.byPath(name.substring(0, sepNdx + 1)).selectSummaryView().getID();
            name = name.substring(sepNdx + 1);
        }
        return SingleComponentQuery.byName(folderID, name, version).select();
    }
}

