/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;

public abstract class SystemServiceRefEditBase
extends SessionBase {
    private String mName;
    private String mDescription;
    private String mInstCompName;
    private String mInstCompVersion;
    private String mInstCompPath;
    private SystemServiceRef mResult;

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setInstCompName(String instCompName) {
        this.mInstCompName = instCompName;
    }

    public String getInstCompName() {
        return this.mInstCompName;
    }

    public String getInstCompVersion() {
        return this.mInstCompVersion;
    }

    public void setInstCompVersion(String instCompVersion) {
        this.mInstCompVersion = instCompVersion;
    }

    public void setInstCompPath(String instCompPath) {
        this.mInstCompPath = instCompPath;
    }

    public String getInstCompPath() {
        return this.mInstCompPath;
    }

    protected void setResult(SystemServiceRef result) {
        this.mResult = result;
    }

    public SystemServiceRef getResult() {
        return this.mResult;
    }

    private void setSystemServiceRef(SystemServiceRef ssr) throws Exception {
        if (this.getName() != null) {
            ssr.setSimpleName(this.getName());
        }
        if (this.getDescription() != null) {
            ssr.setDescription(this.getDescription());
        }
        if (this.getInstCompName() != null || this.getInstCompVersion() != null || this.getInstCompPath() != null) {
            String name = null;
            FolderID folderID = null;
            String version = null;
            String installPath = null;
            InstalledComponentRef ref = ssr.getInstalledComponentRef();
            if (ref != null) {
                folderID = ref.getPath();
                name = ref.getComponentName();
                version = ref.getComponentVersion();
                installPath = ref.getInstallPath();
            }
            if (this.getInstCompName() != null) {
                String fullName = this.getInstCompName();
                int sepNdx = fullName.lastIndexOf("/");
                if (sepNdx == -1) {
                    folderID = FolderID.ROOT_FOLDER_ID;
                    name = fullName;
                } else {
                    folderID = SingleFolderQuery.byPath(fullName.substring(0, sepNdx + 1)).selectSummaryView().getID();
                    name = fullName.substring(sepNdx + 1);
                }
            }
            if (this.getInstCompVersion() != null) {
                version = this.getInstCompVersion();
            }
            if (this.getInstCompPath() != null) {
                installPath = this.getInstCompPath();
            }
            ref = new InstalledComponentRef(folderID, name, version, Comparator.EQUAL, false, installPath, false);
            ssr.setInstalledComponentRef(ref);
        }
    }

    public abstract SystemServiceRef getTarget();

    public void execute() throws Exception {
        SystemServiceRef ssr = this.getTarget();
        this.setSystemServiceRef(ssr);
        ssr.save();
        this.setResult(ssr);
    }
}

