/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.ui.Context;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String PACKAGE_PREFIX = "ui.cdb";
    public static final String MSG_EX_WRONG_NUMBER_OF_RESOURCES = "ui.cdb.EX_WRONG_NUMBER_OF_RESOURCES";
    public static final String MSG_EX_CANNOT_RESOLVE_RESOURCES = "ui.cdb.EX_CANNOT_RESOLVE_RESOURCES";
    public static final String MSG_EX_COMPONENT_NAME_REQUIRED = "ui.cdb.EX_COMPONENT_NAME_REQUIRED";
    public static final String MSG_EX_SIMPLE_COMPONENT = "ui.cdb.EX_SIMPLE_COMPONENT";
    public static final String MSG_EX_FWD_SLASH_REQUIRED = "ui.cdb.EX_FWD_SLASH_REQUIRED";
    public static final String MSG_EX_MISSING_INPUT_PARAMETERS = "ui.cdb.EX_MISSING_INPUT_PARAMETERS";
    public static final String MSG_EX_TOO_MANY_INPUT_PARAMETERS = "ui.cdb.EX_TOO_MANY_INPUT_PARAMETERS";

    private PackageInfo() {
    }

    public static IllegalArgumentException throwResourceVersionsNotRequired() {
        return new IllegalArgumentException(Context.getMessageText(MSG_EX_SIMPLE_COMPONENT));
    }

    public static void throwIllegalNumberOfResources(int correctnumber) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_WRONG_NUMBER_OF_RESOURCES, Integer.toString(correctnumber)));
    }

    public static void throwCannotResolveResource(int index, String resourceName) {
        throw new IllegalArgumentException(PackageInfo.toText(MSG_EX_CANNOT_RESOLVE_RESOURCES, Integer.toString(index), resourceName));
    }

    public static void throwComponentNameRequired() {
        throw new IllegalArgumentException(MSG_EX_COMPONENT_NAME_REQUIRED);
    }

    public static void throwMissingInputParameters() {
        throw new IllegalArgumentException(Context.getMessageText(MSG_EX_MISSING_INPUT_PARAMETERS));
    }

    public static void throwTooManyInputParameters() {
        throw new IllegalArgumentException(Context.getMessageText(MSG_EX_TOO_MANY_INPUT_PARAMETERS));
    }

    public static void throwFwdSlashRequired() {
        throw new IllegalArgumentException(Context.getMessageText(MSG_EX_FWD_SLASH_REQUIRED));
    }

    public static String toText(String messageKey, Object arg) {
        return Context.getMessageText(messageKey, arg);
    }

    public static String toText(String messageKey, Object arg, Object arg2) {
        return Context.getMessageText(messageKey, arg, arg2);
    }
}

