/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Vector;

public class InstalledComponentListByHost
extends SessionBase {
    private static CommandHelp sHelp = new InstalledComponentListByHostHelp();
    private HostID mHostID;
    private CategoryID mCategoryFilter = null;
    private InstalledComponentBean[] mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$componentdb$commands$InstalledComponentListByHost;

    public HostID getHostID() {
        return this.mHostID;
    }

    public void setHostID(HostID hostID) {
        this.mHostID = hostID;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID inFilter) {
        this.mCategoryFilter = inFilter;
    }

    protected void setResult(InstalledComponentBean[] result) {
        this.mResult = result;
    }

    public InstalledComponentBean[] getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        MultiInstalledComponentQuery query = MultiInstalledComponentQuery.byHost(this.getHostID(), TargetType.CURRENT);
        query.setCategoryFilter(this.getCategoryFilter());
        query.setRetrieveCreatedTarget(true);
        this.setResult(query.select());
    }

    protected static class InstalledComponentListByHostHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cdb.ic.lbh.";
        private static final String MSG_HOSTID_DESC = "KEY:ui.cdb.ic.lbh.HOSTID_DESC";
        private static final String MSG_CATEGORY_FILTER_DESC = "KEY:ui.cdb.ic.lbh.CATEGORY_FILTER_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.cdb.ic.lbh.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.cdb.ic.lbh.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredArgInfo("hostID", MSG_HOSTID_DESC, "host"));
            map.addElement(new CommandHelpBase.OptionalArgInfo("categoryFilter", MSG_CATEGORY_FILTER_DESC, "cat"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        InstalledComponentListByHostHelp() {
            super(class$com$raplix$rolloutexpress$ui$componentdb$commands$InstalledComponentListByHost == null ? (class$com$raplix$rolloutexpress$ui$componentdb$commands$InstalledComponentListByHost = InstalledComponentListByHost.class$("com.raplix.rolloutexpress.ui.componentdb.commands.InstalledComponentListByHost")) : class$com$raplix$rolloutexpress$ui$componentdb$commands$InstalledComponentListByHost, MSG_COMMAND_DESC);
        }
    }
}

