/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiDependencyQuery;
import com.raplix.rolloutexpress.ui.CommandHelp;
import com.raplix.rolloutexpress.ui.commands.CommandHelpBase;
import com.raplix.rolloutexpress.ui.componentdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import java.util.Arrays;
import java.util.Vector;

public class DependantComponentListByInstalledComponent
extends SessionBase {
    private static final CommandHelp sHelp = new DependantComponentListByInstalledComponentHelp();
    private InstalledComponentID mInstalledComponentID;
    private InstalledComponentID[] mInstalledComponentIDs;
    private Dependency[] mResult;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$ui$componentdb$commands$DependantComponentListByInstalledComponent;

    public InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    public InstalledComponentID[] getInstalledComponentIDs() {
        return this.mInstalledComponentIDs;
    }

    public void setInstalledComponentID(InstalledComponentID installedComponentID) {
        this.mInstalledComponentID = installedComponentID;
    }

    public void setInstalledComponentIDs(InstalledComponentID[] installedComponentIDs) {
        this.mInstalledComponentIDs = installedComponentIDs;
    }

    protected void setResult(Dependency[] result) {
        this.mResult = result;
    }

    public Dependency[] getResult() {
        return this.mResult;
    }

    public CommandHelp getHelp() {
        return sHelp;
    }

    public void execute() throws Exception {
        InstalledComponentID[] idSet;
        if (this.getInstalledComponentID() == null && this.getInstalledComponentIDs() == null) {
            PackageInfo.throwMissingInputParameters();
        }
        if (this.getInstalledComponentID() != null && this.getInstalledComponentIDs() != null) {
            PackageInfo.throwTooManyInputParameters();
        }
        if ((idSet = this.getInstalledComponentIDs()) != null) {
            InstalledComponentIDSet icIDSet = new InstalledComponentIDSet(Arrays.asList(idSet));
            MultiDependencyQuery mdq = icIDSet.getDependantsOfQuery();
            this.setResult(mdq.select());
        } else {
            this.setResult(MultiDependencyQuery.byDependantsOf(this.getInstalledComponentID()).select());
        }
    }

    protected static class DependantComponentListByInstalledComponentHelp
    extends SessionBase.SessionBaseHelp {
        private static final String COMMAND_PREFIX = "KEY:ui.cdb.ic.lod.";
        private static final String MSG_ID_DESC = "KEY:ui.cdb.ic.lod.ID_DESC";
        private static final String MSG_ID_SET_DESC = "KEY:ui.cdb.ic.lod.ID_SET_DESC";
        private static final String MSG_RESULT_DESC = "KEY:ui.cdb.ic.lod.RESULT_DESC";
        private static final String MSG_COMMAND_DESC = "KEY:ui.cdb.ic.lod.COMMAND_DESC";

        protected Vector getArgumentMap() {
            Vector map = super.getArgumentMap();
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("installedComponentID", MSG_ID_DESC, "ID"));
            map.addElement(new CommandHelpBase.RequiredPossiblyArgInfo("installedComponentIDs", MSG_ID_SET_DESC, "IDs"));
            return map;
        }

        protected CommandHelpBase.ResultInfo getResultMap() {
            return new CommandHelpBase.ResultInfo("result", MSG_RESULT_DESC);
        }

        DependantComponentListByInstalledComponentHelp() {
            super(class$com$raplix$rolloutexpress$ui$componentdb$commands$DependantComponentListByInstalledComponent == null ? (class$com$raplix$rolloutexpress$ui$componentdb$commands$DependantComponentListByInstalledComponent = DependantComponentListByInstalledComponent.class$("com.raplix.rolloutexpress.ui.componentdb.commands.DependantComponentListByInstalledComponent")) : class$com$raplix$rolloutexpress$ui$componentdb$commands$DependantComponentListByInstalledComponent, MSG_COMMAND_DESC);
        }
    }
}

