/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.componentdb.commands;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.ui.componentdb.commands.PackageInfo;
import com.raplix.rolloutexpress.ui.userdb.commands.SessionBase;
import com.raplix.rolloutexpress.ui.web.Util;

public abstract class ComponentTypeRefEditBase
extends SessionBase {
    private String mName;
    private String mDescription;
    private String mOrder;
    private String mGroup;
    private Integer mIndentLevel;
    private String mComponent;
    private String mVersion;
    private ComponentTypeRef mResult;

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setOrder(String order) {
        this.mOrder = order;
    }

    public String getOrder() {
        return this.mOrder;
    }

    public void setGroup(String group) {
        this.mGroup = group;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public void setIndentLevel(Integer indentLevel) {
        this.mIndentLevel = indentLevel;
    }

    public Integer getIndentLevel() {
        return this.mIndentLevel;
    }

    public void setComponentRefName(String component) {
        this.mComponent = component;
    }

    public String getComponentRefName() {
        return this.mComponent;
    }

    public void setComponentRefVersion(String version) {
        this.mVersion = version;
    }

    public String getComponentRefVersion() {
        return this.mVersion;
    }

    public void setResult(ComponentTypeRef result) {
        this.mResult = result;
    }

    public ComponentTypeRef getResult() {
        return this.mResult;
    }

    private void setComponentTypeRef(ComponentTypeRef ctr) throws Exception {
        if (this.getName() != null) {
            ctr.setSimpleName(this.getName());
        }
        if (this.getDescription() != null) {
            ctr.setDescription(this.getDescription());
        }
        if (this.getOrder() != null) {
            ctr.setOrder(this.getOrder());
        }
        if (this.getGroup() != null) {
            ctr.setGroup(this.getGroup());
        }
        if (this.getIndentLevel() != null) {
            ctr.setIndentLevel(this.getIndentLevel());
        }
        if (this.getComponentRefName() != null || this.getComponentRefVersion() != null) {
            String name = null;
            FolderID folderID = null;
            String version = null;
            ComponentRef ref = ctr.getComponentRef();
            if (ref != null) {
                folderID = ref.getPath();
                name = ref.getComponentName();
                version = ref.getComponentVersion();
            }
            if (this.getComponentRefName() != null) {
                name = Util.fullNameToShortName(this.getComponentRefName());
                folderID = SingleFolderQuery.byPath(Util.fullNameToPath(this.getComponentRefName())).selectSummaryView().getID();
            } else if (name == null) {
                PackageInfo.throwComponentNameRequired();
            }
            if (this.getComponentRefVersion() != null) {
                version = this.getComponentRefVersion();
            } else if (version == null) {
                version = new VersionNumber().getAsString();
            }
            ref = new ComponentRef(folderID, name, version);
            ctr.setComponentRef(ref);
        }
    }

    public abstract ComponentTypeRef getTarget();

    public void execute() throws Exception {
        ComponentTypeRef ctr = this.getTarget();
        this.setComponentTypeRef(ctr);
        ctr.save();
        this.setResult(ctr);
    }
}

